/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ColourScheme;
import jalview.Consensus;
import jalview.ConsensusColour;
import jalview.DrawableSequence;
import jalview.SequenceGroup;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

public class ClustalxColourScheme
implements ColourScheme {
    Hashtable[] cons;
    int[][] cons2;
    ConsensusColour[] colours;
    ConsensusColour[] ResidueColour;
    int size;
    Hashtable colhash = new Hashtable();
    Consensus[] conses = new Consensus[32];
    Vector colourTable = new Vector();

    public ClustalxColourScheme() {
        this.cons2 = null;
        this.size = 0;
        this.makeColours();
    }

    public ClustalxColourScheme(int[][] nArray, int n) {
        this.cons2 = nArray;
        this.size = n;
        this.makeColours();
    }

    public void makeColours() {
        this.colhash.put("RED", new Color(0.9f, 0.2f, 0.1f));
        this.colhash.put("BLUE", new Color(0.5f, 0.7f, 0.9f));
        this.colhash.put("GREEN", new Color(0.1f, 0.8f, 0.1f));
        this.colhash.put("ORANGE", new Color(0.9f, 0.6f, 0.3f));
        this.colhash.put("CYAN", new Color(0.1f, 0.7f, 0.7f));
        this.colhash.put("PINK", new Color(0.9f, 0.5f, 0.5f));
        this.colhash.put("MAGENTA", new Color(0.8f, 0.3f, 0.8f));
        this.colhash.put("YELLOW", new Color(0.8f, 0.8f, 0.0f));
        this.conses[0] = new Consensus("WLVIMAFCYHP", 60.0);
        this.conses[1] = new Consensus("WLVIMAFCYHP", 80.0);
        this.conses[2] = new Consensus("ED", 50.0);
        this.conses[3] = new Consensus("KR", 60.0);
        this.conses[4] = new Consensus("G", 50.0);
        this.conses[5] = new Consensus("N", 50.0);
        this.conses[6] = new Consensus("QE", 50.0);
        this.conses[7] = new Consensus("P", 50.0);
        this.conses[8] = new Consensus("TS", 50.0);
        this.conses[26] = new Consensus("A", 85.0);
        this.conses[27] = new Consensus("C", 85.0);
        this.conses[10] = new Consensus("E", 85.0);
        this.conses[11] = new Consensus("F", 85.0);
        this.conses[12] = new Consensus("G", 85.0);
        this.conses[13] = new Consensus("H", 85.0);
        this.conses[14] = new Consensus("I", 85.0);
        this.conses[15] = new Consensus("L", 85.0);
        this.conses[16] = new Consensus("M", 85.0);
        this.conses[17] = new Consensus("N", 85.0);
        this.conses[18] = new Consensus("P", 85.0);
        this.conses[19] = new Consensus("Q", 85.0);
        this.conses[20] = new Consensus("R", 85.0);
        this.conses[21] = new Consensus("S", 85.0);
        this.conses[22] = new Consensus("T", 85.0);
        this.conses[23] = new Consensus("V", 85.0);
        this.conses[24] = new Consensus("W", 85.0);
        this.conses[25] = new Consensus("Y", 85.0);
        this.conses[28] = new Consensus("K", 85.0);
        this.conses[29] = new Consensus("D", 85.0);
        this.conses[30] = new Consensus("G", 0.0);
        this.conses[31] = new Consensus("P", 0.0);
        this.colours = new ConsensusColour[11];
        Consensus[] consensusArray = new Consensus[]{this.conses[30]};
        this.colours[7] = new ConsensusColour((Color)this.colhash.get("ORANGE"), consensusArray);
        Consensus[] consensusArray2 = new Consensus[]{this.conses[31]};
        this.colours[8] = new ConsensusColour((Color)this.colhash.get("YELLOW"), consensusArray2);
        Consensus[] consensusArray3 = new Consensus[]{this.conses[27]};
        this.colours[9] = new ConsensusColour((Color)this.colhash.get("PINK"), consensusArray);
        Consensus[] consensusArray4 = new Consensus[]{this.conses[0], this.conses[1], this.conses[26], this.conses[27], this.conses[11], this.conses[13], this.conses[14], this.conses[15], this.conses[16], this.conses[23], this.conses[24], this.conses[25], this.conses[18], this.conses[19]};
        this.colours[0] = new ConsensusColour((Color)this.colhash.get("BLUE"), consensusArray4);
        this.colours[10] = new ConsensusColour((Color)this.colhash.get("CYAN"), consensusArray4);
        Consensus[] consensusArray5 = new Consensus[]{this.conses[8], this.conses[21], this.conses[22], this.conses[0], this.conses[1]};
        this.colours[1] = new ConsensusColour((Color)this.colhash.get("GREEN"), consensusArray5);
        Consensus[] consensusArray6 = new Consensus[]{this.conses[17], this.conses[29], this.conses[5]};
        this.colours[2] = new ConsensusColour((Color)this.colhash.get("GREEN"), consensusArray6);
        Consensus[] consensusArray7 = new Consensus[]{this.conses[6], this.conses[19], this.conses[22], this.conses[3], this.conses[28], this.conses[20]};
        this.colours[3] = new ConsensusColour((Color)this.colhash.get("GREEN"), consensusArray7);
        Consensus[] consensusArray8 = new Consensus[]{this.conses[3], this.conses[28], this.conses[20], this.conses[19]};
        this.colours[4] = new ConsensusColour((Color)this.colhash.get("RED"), consensusArray8);
        Consensus[] consensusArray9 = new Consensus[]{this.conses[3], this.conses[29], this.conses[10], this.conses[6], this.conses[19]};
        this.colours[5] = new ConsensusColour((Color)this.colhash.get("MAGENTA"), consensusArray9);
        Consensus[] consensusArray10 = new Consensus[]{this.conses[3], this.conses[29], this.conses[10], this.conses[17], this.conses[2]};
        this.colours[6] = new ConsensusColour((Color)this.colhash.get("MAGENTA"), consensusArray10);
        this.ResidueColour = new ConsensusColour[20];
        this.ResidueColour[0] = this.colours[0];
        this.ResidueColour[1] = this.colours[4];
        this.ResidueColour[2] = this.colours[2];
        this.ResidueColour[3] = this.colours[6];
        this.ResidueColour[4] = this.colours[0];
        this.ResidueColour[5] = this.colours[3];
        this.ResidueColour[6] = this.colours[5];
        this.ResidueColour[7] = this.colours[7];
        this.ResidueColour[8] = this.colours[10];
        this.ResidueColour[9] = this.colours[0];
        this.ResidueColour[10] = this.colours[0];
        this.ResidueColour[11] = this.colours[4];
        this.ResidueColour[12] = this.colours[0];
        this.ResidueColour[13] = this.colours[0];
        this.ResidueColour[14] = this.colours[8];
        this.ResidueColour[15] = this.colours[1];
        this.ResidueColour[16] = this.colours[1];
        this.ResidueColour[17] = this.colours[0];
        this.ResidueColour[18] = this.colours[10];
        this.ResidueColour[19] = this.colours[0];
    }

    public Color findColour(DrawableSequence drawableSequence, String string, int n) {
        int n2 = drawableSequence.num[n];
        Color color = Color.white;
        int n3 = 0;
        while (n3 < this.ResidueColour[n2].conses.length) {
            if (this.ResidueColour[n2].conses[n3].isConserved(this.cons2, n, drawableSequence.num[n], this.size)) {
                color = this.ResidueColour[n2].c;
            }
            ++n3;
        }
        if (n2 == 4 && this.conses[27].isConserved(this.cons2, n, drawableSequence.num[n], this.size)) {
            color = (Color)this.colhash.get("PINK");
        }
        return color;
    }

    public void setColours(DrawableSequence drawableSequence, int n) {
        Color color = Color.white;
        String string = drawableSequence.getSequence().substring(n, n + 1);
        try {
            color = this.findColour(drawableSequence, string, n);
            drawableSequence.setResidueBoxColour(n, color);
            return;
        }
        catch (Exception exception) {
            drawableSequence.setResidueBoxColour(n, Color.white);
            return;
        }
    }

    public void setColours(DrawableSequence drawableSequence) {
        int n = 0;
        while (n < drawableSequence.sequence.length()) {
            this.setColours(drawableSequence, n);
            ++n;
        }
    }

    public void setColours(SequenceGroup sequenceGroup) {
        int n = 0;
        while (n < sequenceGroup.sequences.size()) {
            DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n);
            int n2 = 0;
            while (n2 < drawableSequence.getSequence().length()) {
                this.setColours(drawableSequence, n2);
                ++n2;
            }
            ++n;
        }
    }
}

