/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class BuildQueuePanel
extends FreeColPanel
implements ItemListener {
    private static final Logger logger = Logger.getLogger(BuildQueuePanel.class.getName());
    private static final DataFlavor BUILD_LIST_FLAVOR = new DataFlavor(List.class, "IndexedBuildableFlavor");
    private static final String FAIL = "FAIL";
    private static final String BUY = "buy";
    private static final int UNABLE_TO_BUILD = -1;
    private static boolean defaultCompact = false;
    private static boolean defaultShowAll = false;
    private final Colony colony;
    private final FeatureContainer featureContainer;
    private final BuildQueueTransferHandler buildQueueHandler = new BuildQueueTransferHandler();
    private final JList<UnitType> unitList;
    private final ConstructionPanel constructionPanel;
    private final JList<BuildableType> buildQueueList;
    private final JList<BuildingType> buildingList;
    private final JButton buyBuildable;
    private final JCheckBox compactBox;
    private final JCheckBox showAllBox;
    private final Map<BuildableType, String> lockReasons = new HashMap<BuildableType, String>();

    public BuildQueuePanel(FreeColClient freeColClient, Colony colony) {
        super(freeColClient, null, new MigLayout("fill, wrap 3", "[150:260:][fill][150:260:]", "[][][150:400:, growprio 150,shrinkprio 50][]"));
        this.colony = colony;
        this.featureContainer = new FeatureContainer();
        DefaultListModel<BuildableType> current = new DefaultListModel<BuildableType>();
        for (BuildableType type : this.colony.getBuildQueue()) {
            current.addElement(type);
            this.featureContainer.addFeatures(type);
        }
        BuildQueueMouseAdapter adapter = new BuildQueueMouseAdapter(true);
        AbstractAction addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JList<UnitType> btl;
                JList<BuildableType> bql = BuildQueuePanel.this.buildQueueList;
                DefaultListModel model = (DefaultListModel)bql.getModel();
                JList<BuildableType> jList = ae.getSource() == BuildQueuePanel.this.unitList ? BuildQueuePanel.this.unitList : (btl = ae.getSource() == BuildQueuePanel.this.buildingList ? BuildQueuePanel.this.buildingList : null);
                if (btl != null) {
                    for (BuildableType buildableType : btl.getSelectedValuesList()) {
                        model.addElement(buildableType);
                    }
                }
                BuildQueuePanel.this.updateAllLists();
            }
        };
        Font fontSubHead = FontLibrary.getScaledFont("normal-bold-smaller");
        JLabel header = Utility.localizedHeaderLabel("buildQueuePanel.buildQueue", 10, Utility.FONTSPEC_TITLE);
        JLabel bqpUnits = Utility.localizedLabel("buildQueuePanel.units");
        bqpUnits.setFont(fontSubHead);
        JLabel bpqBuildQueue = Utility.localizedLabel("buildQueuePanel.buildQueue");
        bpqBuildQueue.setFont(fontSubHead);
        bpqBuildQueue.setHorizontalAlignment(0);
        JLabel bqpBuildings = Utility.localizedLabel("buildQueuePanel.buildings");
        bqpBuildings.setFont(fontSubHead);
        DefaultListModel units = new DefaultListModel();
        this.unitList = new JList(units);
        this.unitList.setTransferHandler(this.buildQueueHandler);
        this.unitList.setSelectionMode(2);
        this.unitList.setDragEnabled(true);
        this.unitList.addMouseListener(adapter);
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "add");
        this.unitList.getActionMap().put("add", addAction);
        this.constructionPanel = new ConstructionPanel(freeColClient, this.colony, false);
        this.constructionPanel.setDefaultLabel((StringTemplate)StringTemplate.template("buildQueuePanel.currentlyBuilding").add("%buildable%", "nothing"));
        this.buildQueueList = new JList(current);
        this.buildQueueList.setTransferHandler(this.buildQueueHandler);
        this.buildQueueList.setSelectionMode(0);
        this.buildQueueList.setDragEnabled(true);
        this.buildQueueList.addMouseListener(new BuildQueueMouseAdapter(false));
        this.buildQueueList.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.buildQueueList.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JList<BuildableType> bql = BuildQueuePanel.this.buildQueueList;
                for (BuildableType bt : bql.getSelectedValuesList()) {
                    BuildQueuePanel.this.removeBuildable(bt);
                }
                BuildQueuePanel.this.updateAllLists();
            }
        });
        DefaultListModel buildings = new DefaultListModel();
        this.buildingList = new JList(buildings);
        this.buildingList.setTransferHandler(this.buildQueueHandler);
        this.buildingList.setSelectionMode(2);
        this.buildingList.setDragEnabled(true);
        this.buildingList.addMouseListener(adapter);
        this.buildingList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "add");
        this.buildingList.getActionMap().put("add", addAction);
        this.buyBuildable = Utility.localizedButton("none");
        this.setBuyLabel(null);
        this.buyBuildable.setActionCommand(BUY);
        this.buyBuildable.addActionListener(this);
        this.compactBox = new JCheckBox(Messages.message("buildQueuePanel.compactView"));
        this.compactBox.addItemListener(this);
        this.compactBox.setSelected(defaultCompact);
        this.showAllBox = new JCheckBox(Messages.message("buildQueuePanel.showAll"));
        this.showAllBox.addItemListener(this);
        this.showAllBox.setSelected(defaultShowAll);
        this.updateDetailView();
        this.updateAllLists();
        this.add((Component)header, "span 3, align center, wrap 40");
        this.add((Component)bqpUnits, "align center");
        this.add((Component)bpqBuildQueue, "align center");
        this.add((Component)bqpBuildings, "align center");
        this.add((Component)new JScrollPane(this.unitList), "grow");
        this.add((Component)this.constructionPanel, "split 2, flowy");
        this.add((Component)new JScrollPane(this.buildQueueList), "grow");
        this.add((Component)new JScrollPane(this.buildingList), "grow, wrap 20");
        this.add((Component)this.buyBuildable, "span, split 4");
        this.add(this.compactBox);
        this.add(this.showAllBox);
        this.add((Component)this.okButton, "tag ok");
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BuildQueuePanel.this.okButton.doClick();
            }
        });
        this.setSize(this.getPreferredSize());
    }

    public Colony getColony() {
        return this.colony;
    }

    private JList<? extends BuildableType> convertJComp(JComponent comp) {
        return comp == this.unitList ? this.unitList : (comp == this.buildQueueList ? this.buildQueueList : (comp == this.buildingList ? this.buildingList : null));
    }

    private void removeBuildable(Object type) {
        DefaultListModel model = (DefaultListModel)this.buildQueueList.getModel();
        model.removeElement(type);
    }

    private boolean checkAbilities(BuildableType bt, List<String> lockReason) {
        Specification spec = this.getSpecification();
        int oldSize = lockReason.size();
        CollectionUtils.forEachMapEntry(bt.getRequiredAbilities(), e -> {
            String id = (String)e.getKey();
            boolean value = (Boolean)e.getValue();
            if (this.featureContainer.hasAbility(id, null, null) != value && this.colony.hasAbility(id) != value) {
                FreeColSpecObjectType source = CollectionUtils.first(spec.getTypesProviding(id, value));
                lockReason.add(source != null ? Messages.getName(source) : Messages.getName(bt));
            }
        });
        return lockReason.size() == oldSize;
    }

    private void updateBuildingList() {
        Specification spec = this.getSpecification();
        DefaultListModel current = (DefaultListModel)this.buildQueueList.getModel();
        DefaultListModel buildings = (DefaultListModel)this.buildingList.getModel();
        buildings.clear();
        HashSet<BuildingType> unbuildableTypes = new HashSet<BuildingType>();
        for (BuildingType bt : spec.getBuildingTypeList()) {
            if (unbuildableTypes.contains(bt)) continue;
            if (bt.getUpgradesFrom() != null && unbuildableTypes.contains(bt.getUpgradesFrom())) {
                unbuildableTypes.add(bt);
                continue;
            }
            if (!bt.needsGoodsToBuild() || current.contains(bt) || this.hasBuildingType(bt)) continue;
            ArrayList<String> reasons = new ArrayList<String>(8);
            if (bt.hasAbility("model.ability.coastalOnly") && !this.colony.getTile().isCoastland()) {
                reasons.add(Messages.message(StringTemplate.template("buildQueuePanel.coastalOnly")));
            }
            if (bt.getRequiredPopulation() > this.colony.getUnitCount()) {
                reasons.add(Messages.message(StringTemplate.template("buildQueuePanel.populationTooSmall").addAmount("%number%", bt.getRequiredPopulation())));
            }
            for (Limit limit : CollectionUtils.transform(bt.getLimits(), l -> !l.evaluate(this.colony))) {
                reasons.add(Messages.getDescription(limit));
            }
            if (!this.checkAbilities(bt, reasons)) {
                unbuildableTypes.add(bt);
            }
            Building colonyBuilding = this.colony.getBuilding(bt);
            BuildingType up = bt.getUpgradesFrom();
            if (!(up == null || current.contains(up) || colonyBuilding != null && colonyBuilding.getType() == up)) {
                reasons.add(Messages.getName(up));
            }
            this.lockReasons.put(bt, reasons.isEmpty() ? null : Messages.message(StringTemplate.template("buildQueuePanel.requires").addName("%string%", StringUtils.join("/", reasons))));
            if (!reasons.isEmpty() && !this.showAllBox.isSelected()) continue;
            buildings.addElement(bt);
        }
    }

    private void updateUnitList() {
        Specification spec = this.getSpecification();
        Turn turn = this.getGame().getTurn();
        DefaultListModel units = (DefaultListModel)this.unitList.getModel();
        units.clear();
        HashSet<UnitType> unbuildableTypes = new HashSet<UnitType>();
        for (UnitType ut : spec.getBuildableUnitTypes()) {
            if (unbuildableTypes.contains(ut)) continue;
            ArrayList<String> reasons = new ArrayList<String>(8);
            if (ut.getRequiredPopulation() > this.colony.getUnitCount()) {
                reasons.add(Messages.message(StringTemplate.template("buildQueuePanel.populationTooSmall").addAmount("%number%", ut.getRequiredPopulation())));
            }
            for (Limit limit : CollectionUtils.transform(ut.getLimits(), l -> !l.evaluate(this.colony))) {
                reasons.add(Messages.getDescription(limit));
            }
            if (!this.checkAbilities(ut, reasons)) {
                unbuildableTypes.add(ut);
            }
            if (!this.featureContainer.hasAbility("model.ability.build", ut, null) && !this.colony.hasAbility("model.ability.build", ut, turn)) {
                Ability buildAbility = CollectionUtils.find(spec.getAbilities("model.ability.build"), a -> a.appliesTo(ut) && a.getValue() && a.getSource() != null && !unbuildableTypes.contains(a.getSource()));
                reasons.add(buildAbility != null ? (buildAbility.getSource() instanceof Named ? Messages.getName((Named)((Object)buildAbility.getSource())) : Messages.getName(buildAbility)) : Messages.getName(ut));
            }
            this.lockReasons.put(ut, reasons.isEmpty() ? null : Messages.message(StringTemplate.template("buildQueuePanel.requires").addName("%string%", StringUtils.join("/", reasons))));
            if (!reasons.isEmpty() && !this.showAllBox.isSelected()) continue;
            units.addElement(ut);
        }
    }

    private final void updateAllLists() {
        DefaultListModel current = (DefaultListModel)this.buildQueueList.getModel();
        this.featureContainer.clear();
        Enumeration e = current.elements();
        while (e.hasMoreElements()) {
            BuildableType type = (BuildableType)e.nextElement();
            if (this.getMinimumIndex(type) >= 0) {
                this.featureContainer.addFeatures(type);
                continue;
            }
            current.removeElement(type);
        }
        this.updateBuildingList();
        this.updateUnitList();
        boolean pay = this.getSpecification().getBoolean("model.option.payForBuilding");
        BuildableType bt = current.getSize() <= 0 ? null : (BuildableType)current.getElementAt(0);
        this.buyBuildable.setEnabled(bt != null && pay && this.colony.canPayToFinishBuilding(bt));
        this.setBuyLabel(bt);
        if (current.getSize() > 0) {
            this.constructionPanel.update((BuildableType)current.getElementAt(0));
        } else if (current.getSize() == 0) {
            this.constructionPanel.update();
        }
    }

    private void setBuyLabel(BuildableType buildable) {
        this.buyBuildable.setText(Messages.message(buildable == null ? StringTemplate.template("buildQueuePanel.buyBuilding").addStringTemplate("%buildable%", StringTemplate.key("nothing")) : StringTemplate.template("buildQueuePanel.buyBuilding").addNamed("%buildable%", buildable)));
    }

    private boolean hasBuildingType(BuildingType buildingType) {
        while (true) {
            if (this.colony.getBuilding(buildingType) == null) {
                return false;
            }
            if (this.colony.getBuilding(buildingType).getType() == buildingType) {
                return true;
            }
            if (buildingType.getUpgradesTo() == null) break;
            buildingType = buildingType.getUpgradesTo();
        }
        return false;
    }

    private List<BuildableType> getBuildableTypes(JList<? extends BuildableType> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ListModel<? extends BuildableType> model = list.getModel();
        ArrayList<BuildableType> result = new ArrayList<BuildableType>(model.getSize());
        for (int index = 0; index < model.getSize(); ++index) {
            result.add(model.getElementAt(index));
        }
        return result;
    }

    private int getMinimumIndex(BuildableType buildableType) {
        return buildableType.getMinimumIndex(this.getColony(), this.buildQueueList, -1);
    }

    private int getMaximumIndex(BuildableType buildableType) {
        return buildableType.getMaximumIndex(this.getColony(), this.buildQueueList, -1);
    }

    private void updateDetailView() {
        ListCellRenderer cellRenderer = this.compactBox.isSelected() ? new FreeColComboBoxRenderer() : new DefaultBuildQueueCellRenderer();
        this.buildQueueList.setCellRenderer(cellRenderer);
        this.buildingList.setCellRenderer(cellRenderer);
        this.unitList.setCellRenderer(cellRenderer);
    }

    private static void updateCompact(boolean selected) {
        defaultCompact = selected;
    }

    private static void updateLists(boolean selected) {
        defaultShowAll = selected;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.colony.getOwner() == this.getMyPlayer()) {
            BuildableType bt;
            String command = ae.getActionCommand();
            List<BuildableType> buildables = this.getBuildableTypes(this.buildQueueList);
            while ((bt = CollectionUtils.first(buildables)) != null && this.lockReasons.get(bt) != null) {
                this.getGUI().showInformationPanel((FreeColObject)bt, this.colony.getUnbuildableMessage(bt));
                command = FAIL;
                this.removeBuildable(buildables.remove(0));
            }
            this.igc().setBuildQueue(this.colony, buildables);
            if (null != command) {
                switch (command) {
                    case "FAIL": {
                        this.updateAllLists();
                        return;
                    }
                    case "OK": {
                        break;
                    }
                    case "buy": {
                        this.igc().payForBuilding(this.colony);
                        break;
                    }
                    default: {
                        super.actionPerformed(ae);
                    }
                }
            }
        }
        this.getGUI().removeComponent(this);
        this.getGUI().refreshTile(this.colony.getTile());
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.compactBox) {
            this.updateDetailView();
            BuildQueuePanel.updateCompact(this.compactBox.isSelected());
        } else if (event.getSource() == this.showAllBox) {
            this.updateAllLists();
            BuildQueuePanel.updateLists(this.showAllBox.isSelected());
        }
    }

    private class DefaultBuildQueueCellRenderer
    implements ListCellRenderer<BuildableType> {
        private final Dimension buildingDimension = new Dimension(-1, 48);

        @Override
        public Component getListCellRendererComponent(JList<? extends BuildableType> list, BuildableType value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageLibrary lib = BuildQueuePanel.this.getImageLibrary();
            MigPanel panel = new MigPanel(new MigLayout());
            panel.setOpaque(false);
            if (isSelected) {
                panel.setUI((PanelUI)FreeColSelectedPanelUI.createUI(panel));
            }
            JLabel imageLabel = new JLabel(new ImageIcon(BuildQueuePanel.this.getImageLibrary().getBuildableTypeImage(value, this.buildingDimension)));
            JLabel nameLabel = new JLabel(Messages.getName(value));
            String reason = BuildQueuePanel.this.lockReasons.get(value);
            panel.add((Component)imageLabel, "span 1 2");
            if (reason == null) {
                panel.add((Component)nameLabel, "wrap");
            } else {
                panel.add((Component)nameLabel, "split 2");
                panel.add((Component)lib.getLockLabel(), "wrap");
                panel.setToolTipText(reason);
            }
            List<AbstractGoods> required = value.getRequiredGoodsList();
            int size = required.size();
            for (int i = 0; i < size; ++i) {
                AbstractGoods goods = required.get(i);
                ImageIcon icon = new ImageIcon(lib.getSmallGoodsTypeImage(goods.getType()));
                JLabel goodsLabel = new JLabel(Integer.toString(goods.getAmount()), icon, 0);
                if (i == 0 && size > 1) {
                    panel.add((Component)goodsLabel, "split " + size);
                    continue;
                }
                panel.add(goodsLabel);
            }
            return panel;
        }
    }

    private class BuildQueueMouseAdapter
    extends MouseAdapter {
        private boolean add = true;
        private boolean enabled = false;

        public BuildQueueMouseAdapter(boolean add) {
            this.add = add;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JList<? extends BuildableType> jlist;
            if (!this.enabled && e.getClickCount() == 1 && !e.isConsumed()) {
                this.enabled = true;
            }
            if (!this.enabled) {
                return;
            }
            Object source = e.getSource();
            JList<? extends BuildableType> jList = jlist = source instanceof JComponent ? BuildQueuePanel.this.convertJComp((JComponent)source) : null;
            if (jlist == null) {
                return;
            }
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                int index = jlist.locationToIndex(e.getPoint());
                BuildableType bt = jlist.getModel().getElementAt(index);
                BuildQueuePanel.this.getGUI().showColopediaPanel(bt.getId());
            } else if (e.getClickCount() > 1 && !e.isConsumed()) {
                JList<BuildableType> bql = BuildQueuePanel.this.buildQueueList;
                DefaultListModel model = (DefaultListModel)bql.getModel();
                if (jlist.getSelectedIndex() < 0) {
                    jlist.setSelectedIndex(jlist.locationToIndex(e.getPoint()));
                }
                for (int index : jlist.getSelectedIndices()) {
                    if (this.add) {
                        model.addElement(jlist.getModel().getElementAt(index));
                        continue;
                    }
                    model.removeElementAt(index);
                }
                BuildQueuePanel.this.updateAllLists();
            }
        }
    }

    private class BuildQueueTransferHandler
    extends TransferHandler {
        private JList<? extends BuildableType> source = null;

        private BuildQueueTransferHandler() {
        }

        @Override
        public boolean importData(JComponent comp, Transferable data) {
            Object transferData;
            if (!this.canImport(comp, data.getTransferDataFlavors())) {
                return false;
            }
            JList<? extends BuildableType> target = BuildQueuePanel.this.convertJComp(comp);
            if (target == null) {
                logger.warning("Build queue import failed to: " + comp);
                return false;
            }
            try {
                transferData = data.getTransferData(BUILD_LIST_FLAVOR);
            }
            catch (UnsupportedFlavorException | IOException e) {
                logger.log(Level.WARNING, "BuildQueue import", e);
                return false;
            }
            if (!(transferData instanceof List)) {
                return false;
            }
            List transferList = (List)transferData;
            JList<BuildableType> bql = BuildQueuePanel.this.buildQueueList;
            ArrayList<IndexedBuildable> queue = new ArrayList<IndexedBuildable>(transferList.size());
            for (Object object : transferList) {
                if (!(object instanceof IndexedBuildable) || ((IndexedBuildable)object).getBuildable() instanceof UnitType && target == BuildQueuePanel.this.buildingList || ((IndexedBuildable)object).getBuildable() instanceof BuildingType && target == BuildQueuePanel.this.unitList) {
                    return false;
                }
                queue.add((IndexedBuildable)object);
            }
            boolean isOrderingQueue = false;
            if (this.source == bql) {
                if (target != bql) {
                    DefaultListModel sourceModel = (DefaultListModel)this.source.getModel();
                    for (Object e : queue) {
                        sourceModel.removeElement(e);
                    }
                    return true;
                }
                isOrderingQueue = true;
            } else if (target != bql && target.getParent() != bql) {
                return false;
            }
            DefaultListModel targetModel = (DefaultListModel)bql.getModel();
            int preferredIndex = target.getSelectedIndex();
            int n = targetModel.size();
            int prevPos = ((IndexedBuildable)queue.get(0)).getIndex();
            if (isOrderingQueue) {
                if (preferredIndex != -1 && prevPos == preferredIndex) {
                    return false;
                }
                int maximumIndex = BuildQueuePanel.this.getMaximumIndex(((IndexedBuildable)queue.get(0)).getBuildable());
                if (preferredIndex > maximumIndex) {
                    return false;
                }
                for (IndexedBuildable ib : queue) {
                    targetModel.removeElementAt(ib.getIndex());
                }
            }
            if (preferredIndex < 0 || preferredIndex > n) {
                preferredIndex = n;
            }
            for (int index = 0; index < queue.size(); ++index) {
                int maximumIndex;
                BuildableType toBuild = ((IndexedBuildable)queue.get(index)).getBuildable();
                int minimumIndex = BuildQueuePanel.this.getMinimumIndex(toBuild);
                if (minimumIndex < targetModel.size() && minimumIndex != (maximumIndex = BuildQueuePanel.this.getMaximumIndex(toBuild))) {
                    if (minimumIndex < preferredIndex + index) {
                        minimumIndex = preferredIndex + index;
                    }
                    minimumIndex = Math.min(Math.min(minimumIndex, targetModel.size()), maximumIndex);
                }
                targetModel.add(minimumIndex, toBuild);
            }
            if (isOrderingQueue) {
                BuildQueuePanel.this.buildQueueList.setSelectedIndex(preferredIndex);
            }
            return true;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            BuildQueuePanel.this.updateAllLists();
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            return flavors != null && CollectionUtils.any(flavors, CollectionUtils.matchKeyEquals(BUILD_LIST_FLAVOR));
        }

        @Override
        protected Transferable createTransferable(JComponent comp) {
            this.source = BuildQueuePanel.this.convertJComp(comp);
            if (this.source == null) {
                return null;
            }
            int[] indicesArray = this.source.getSelectedIndices();
            List<? extends BuildableType> buildableTypes = this.source.getSelectedValuesList();
            ArrayList<IndexedBuildable> indexedBuildables = new ArrayList<IndexedBuildable>(indicesArray.length);
            int i = 0;
            for (int index : indicesArray) {
                BuildableType bt = buildableTypes.get(i++);
                indexedBuildables.add(new IndexedBuildable(bt, index));
            }
            return new BuildablesTransferable(indexedBuildables);
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return comp == BuildQueuePanel.this.unitList ? 1 : 2;
        }

        public class BuildablesTransferable
        implements Transferable {
            private final List<IndexedBuildable> indexedBuildables;
            private final DataFlavor[] supportedFlavors = new DataFlavor[]{BUILD_LIST_FLAVOR};

            public BuildablesTransferable(List<IndexedBuildable> indexedBuildables) {
                this.indexedBuildables = indexedBuildables;
            }

            public List<IndexedBuildable> getBuildables() {
                return this.indexedBuildables;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return this.indexedBuildables;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return Arrays.copyOf(this.supportedFlavors, this.supportedFlavors.length);
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return CollectionUtils.any(this.supportedFlavors, CollectionUtils.matchKeyEquals(flavor));
            }
        }
    }

    private static class IndexedBuildable {
        private final BuildableType buildable;
        private final int index;

        IndexedBuildable(BuildableType buildable, int index) {
            this.buildable = buildable;
            this.index = index;
        }

        BuildableType getBuildable() {
            return this.buildable;
        }

        int getIndex() {
            return this.index;
        }
    }
}

