/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udp;

import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.datagram.I2PDatagramDissector;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.Log;

public class I2PSource
implements Source {
    protected final I2PSession sess;
    protected Sink sink;
    private final Protocol protocol;
    private final int port;
    private final I2PDatagramDissector diss;
    private final Log log;

    public I2PSource(I2PSession sess) {
        this(sess, Protocol.BOTH);
    }

    public I2PSource(I2PSession sess, Protocol protocol) {
        this(sess, protocol, 0);
    }

    public I2PSource(I2PSession sess, Protocol protocol, int port) {
        this.sess = sess;
        this.protocol = protocol;
        this.port = port;
        this.diss = protocol != Protocol.RAW ? new I2PDatagramDissector() : null;
        this.log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
        Listener l = new Listener();
        if (this.protocol != Protocol.RAW) {
            this.sess.addMuxedSessionListener(l, 17, this.port);
        }
        if (this.protocol != Protocol.REPLIABLE) {
            this.sess.addMuxedSessionListener(l, 18, this.port);
        }
    }

    protected class Listener
    implements I2PSessionMuxedListener {
        protected Listener() {
        }

        @Override
        public void messageAvailable(I2PSession sess, int id, long size) {
            throw new IllegalStateException("muxed");
        }

        @Override
        public void messageAvailable(I2PSession session, int id, long size, int proto, int fromPort, int toPort) {
            block8: {
                if (I2PSource.this.log.shouldDebug()) {
                    I2PSource.this.log.debug("Got " + size + " bytes, proto: " + proto + " from port: " + fromPort + " to port: " + toPort);
                }
                try {
                    byte[] msg = session.receiveMessage(id);
                    if (proto == 17) {
                        I2PSource.this.diss.loadI2PDatagram(msg);
                        I2PSource.this.sink.send(I2PSource.this.diss.getSender(), fromPort, toPort, I2PSource.this.diss.getPayload());
                    } else if (proto == 18) {
                        I2PSource.this.sink.send(null, fromPort, toPort, msg);
                    } else if (I2PSource.this.log.shouldWarn()) {
                        I2PSource.this.log.warn("dropping message with unknown protocol " + proto);
                    }
                }
                catch (Exception e) {
                    if (!I2PSource.this.log.shouldWarn()) break block8;
                    I2PSource.this.log.warn("error receiving datagram", e);
                }
            }
        }

        @Override
        public void reportAbuse(I2PSession arg0, int arg1) {
        }

        @Override
        public void disconnected(I2PSession arg0) {
        }

        @Override
        public void errorOccurred(I2PSession arg0, String arg1, Throwable arg2) {
            I2PSource.this.log.error(arg1, arg2);
        }
    }

    public static enum Protocol {
        REPLIABLE,
        RAW,
        BOTH;

    }
}

