/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javafragment;

import java.util.Arrays;
import java.util.List;
import org.jd.core.v1.model.fragment.FixedFragment;
import org.jd.core.v1.model.javafragment.JavaFragment;
import org.jd.core.v1.model.javafragment.JavaFragmentVisitor;
import org.jd.core.v1.model.token.AbstractNopTokenVisitor;
import org.jd.core.v1.model.token.LineNumberToken;
import org.jd.core.v1.model.token.NewLineToken;
import org.jd.core.v1.model.token.Token;

public class LineNumberTokensFragment
extends FixedFragment
implements JavaFragment {
    protected List<Token> tokens;

    public LineNumberTokensFragment(Token ... tokens) {
        this(Arrays.asList(tokens));
    }

    public LineNumberTokensFragment(List<Token> tokens) {
        super(LineNumberTokensFragment.searchFirstLineNumber(tokens), LineNumberTokensFragment.searchLastLineNumber(tokens));
        assert (this.firstLineNumber != 0) : "Uses 'TokensFragment' instead";
        this.tokens = tokens;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    protected static int searchFirstLineNumber(List<Token> tokens) {
        SearchLineNumberVisitor visitor = new SearchLineNumberVisitor();
        for (Token token : tokens) {
            token.accept(visitor);
            if (visitor.lineNumber == 0) continue;
            return visitor.lineNumber - visitor.newLineCounter;
        }
        return 0;
    }

    protected static int searchLastLineNumber(List<Token> tokens) {
        SearchLineNumberVisitor visitor = new SearchLineNumberVisitor();
        int index = tokens.size();
        while (index-- > 0) {
            tokens.get(index).accept(visitor);
            if (visitor.lineNumber == 0) continue;
            return visitor.lineNumber + visitor.newLineCounter;
        }
        return 0;
    }

    @Override
    public void accept(JavaFragmentVisitor visitor) {
        visitor.visit(this);
    }

    protected static class SearchLineNumberVisitor
    extends AbstractNopTokenVisitor {
        public int lineNumber;
        public int newLineCounter;

        protected SearchLineNumberVisitor() {
        }

        public void reset() {
            this.lineNumber = 0;
            this.newLineCounter = 0;
        }

        @Override
        public void visit(LineNumberToken token) {
            this.lineNumber = token.getLineNumber();
        }

        @Override
        public void visit(NewLineToken token) {
            ++this.newLineCounter;
        }
    }
}

