/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class PskIdentity {
    protected byte[] identity;
    protected long obfuscatedTicketAge;

    public PskIdentity(byte[] byArray, long l) {
        if (null == byArray) {
            throw new IllegalArgumentException("'identity' cannot be null");
        }
        if (byArray.length < 1 || !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'identity' should have length from 1 to 65535");
        }
        if (!TlsUtils.isValidUint32(l)) {
            throw new IllegalArgumentException("'obfuscatedTicketAge' should be a uint32");
        }
        this.identity = byArray;
        this.obfuscatedTicketAge = l;
    }

    public int getEncodedLength() {
        return 6 + this.identity.length;
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    public long getObfuscatedTicketAge() {
        return this.obfuscatedTicketAge;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque16(this.identity, outputStream);
        TlsUtils.writeUint32(this.obfuscatedTicketAge, outputStream);
    }

    public static PskIdentity parse(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        long l = TlsUtils.readUint32(inputStream);
        return new PskIdentity(byArray, l);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PskIdentity)) {
            return false;
        }
        PskIdentity pskIdentity = (PskIdentity)object;
        return this.obfuscatedTicketAge == pskIdentity.obfuscatedTicketAge && Arrays.constantTimeAreEqual(this.identity, pskIdentity.identity);
    }

    public int hashCode() {
        return Arrays.hashCode(this.identity) ^ (int)this.obfuscatedTicketAge ^ (int)(this.obfuscatedTicketAge >>> 32);
    }
}

