/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.yaml;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereSpellCheckResult;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereStatisticianService;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereStatisticianStats;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.navigation.YAMLKeyNavigationItem;
import org.jetbrains.yaml.navigation.YAMLKeysSearchEverywhereContributor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0016JD\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00162\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00162\u0006\u0010\t\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00162\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/yaml/SEYamlKeyFeaturesProvider;", "Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereElementFeaturesProvider;", "<init>", "()V", "getFeaturesDeclarations", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getElementFeatures", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "correction", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereSpellCheckResult;", "getKeyNameMatchingFeatures", "", "Lcom/intellij/navigation/NavigationItem;", "getStatisticianFeatures", "Lorg/jetbrains/yaml/navigation/YAMLKeyNavigationItem;", "getFileFeatures", "getRecentFilesIndex", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Fields", "intellij.searchEverywhereMl.ranking.yaml"})
@SourceDebugExtension(value={"SMAP\nSEYamlKeyFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SEYamlKeyFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/yaml/SEYamlKeyFeaturesProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,107:1\n40#2,3:108\n*S KotlinDebug\n*F\n+ 1 SEYamlKeyFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/yaml/SEYamlKeyFeaturesProvider\n*L\n71#1:108,3\n*E\n"})
final class SEYamlKeyFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    public SEYamlKeyFeaturesProvider() {
        Class[] classArray = new Class[]{YAMLKeysSearchEverywhereContributor.class};
        super(classArray);
    }

    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        Object[] objectArray = new PrimitiveEventField[]{Fields.INSTANCE.getKEY_IS_MOST_RECENTLY_USED(), Fields.INSTANCE.getKEY_IS_IN_TOP_5_RECENTLY_USED(), Fields.INSTANCE.getKEY_NEVER_USED(), Fields.INSTANCE.getKEY_IS_MOST_POPULAR(), Fields.INSTANCE.getFILE_RECENCY_INDEX(), Fields.INSTANCE.getFILE_TIME_SINCE_LAST_MODIFICATION(), Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_HOUR(), Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_DAY(), Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_WEEK(), Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_MONTH()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache, @NotNull SearchEverywhereSpellCheckResult correction) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter((Object)correction, (String)"correction");
        if (!(element instanceof YAMLKeyNavigationItem)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus(this.getKeyNameMatchingFeatures((NavigationItem)element, searchQuery), (Iterable)this.getStatisticianFeatures((YAMLKeyNavigationItem)element)), (Iterable)this.getFileFeatures((YAMLKeyNavigationItem)element, currentTime));
    }

    private final Collection<EventPair<?>> getKeyNameMatchingFeatures(NavigationItem element, String searchQuery) {
        String string = element.getName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String name = string;
        return this.getNameMatchingFeatures(name, searchQuery);
    }

    private final Collection<EventPair<?>> getStatisticianFeatures(YAMLKeyNavigationItem element) {
        boolean $i$f$service = false;
        Class<SearchEverywhereStatisticianService> serviceClass$iv = SearchEverywhereStatisticianService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SearchEverywhereStatisticianStats searchEverywhereStatisticianStats = ((SearchEverywhereStatisticianService)object).getCombinedStats((Object)element);
        if (searchEverywhereStatisticianStats == null) {
            return CollectionsKt.emptyList();
        }
        SearchEverywhereStatisticianStats stats = searchEverywhereStatisticianStats;
        Object[] objectArray = new EventPair[]{Fields.INSTANCE.getKEY_IS_MOST_RECENTLY_USED().with((Object)stats.isMostRecent()), Fields.INSTANCE.getKEY_IS_IN_TOP_5_RECENTLY_USED().with((Object)(stats.getRecency() < 5 ? 1 : 0)), Fields.INSTANCE.getKEY_NEVER_USED().with((Object)(stats.getRecency() == Integer.MAX_VALUE ? 1 : 0)), Fields.INSTANCE.getKEY_IS_MOST_POPULAR().with((Object)stats.isMostPopular())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Collection<EventPair<?>> getFileFeatures(YAMLKeyNavigationItem element, long currentTime) {
        long timeSinceLastModification = currentTime - element.getFile().getTimeStamp();
        Object[] objectArray = new EventPair[6];
        IntEventField intEventField = Fields.INSTANCE.getFILE_RECENCY_INDEX();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = element.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        objectArray[0] = intEventField.with((Object)this.getRecentFilesIndex(project, virtualFile));
        objectArray[1] = Fields.INSTANCE.getFILE_TIME_SINCE_LAST_MODIFICATION().with((Object)timeSinceLastModification);
        objectArray[2] = Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_HOUR().with((Object)(timeSinceLastModification <= 3600000L ? 1 : 0));
        objectArray[3] = Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_DAY().with((Object)(timeSinceLastModification <= 86400000L ? 1 : 0));
        objectArray[4] = Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_WEEK().with((Object)(timeSinceLastModification <= 604800000L ? 1 : 0));
        objectArray[5] = Fields.INSTANCE.getFILE_MODIFIED_IN_LAST_MONTH().with((Object)(timeSinceLastModification <= 2419200000L ? 1 : 0));
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final int getRecentFilesIndex(Project project, VirtualFile file) {
        EditorHistoryManager historyManager = EditorHistoryManager.Companion.getInstance(project);
        List recentFilesList = historyManager.getFileList();
        int fileIndex = recentFilesList.indexOf(file);
        if (fileIndex == -1) {
            return fileIndex;
        }
        return recentFilesList.size() - fileIndex;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/yaml/SEYamlKeyFeaturesProvider$Fields;", "", "<init>", "()V", "KEY_IS_MOST_RECENTLY_USED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getKEY_IS_MOST_RECENTLY_USED", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "KEY_IS_IN_TOP_5_RECENTLY_USED", "getKEY_IS_IN_TOP_5_RECENTLY_USED", "KEY_NEVER_USED", "getKEY_NEVER_USED", "KEY_IS_MOST_POPULAR", "getKEY_IS_MOST_POPULAR", "FILE_RECENCY_INDEX", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getFILE_RECENCY_INDEX", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "FILE_TIME_SINCE_LAST_MODIFICATION", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "getFILE_TIME_SINCE_LAST_MODIFICATION", "()Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "FILE_MODIFIED_IN_LAST_HOUR", "getFILE_MODIFIED_IN_LAST_HOUR", "FILE_MODIFIED_IN_LAST_DAY", "getFILE_MODIFIED_IN_LAST_DAY", "FILE_MODIFIED_IN_LAST_WEEK", "getFILE_MODIFIED_IN_LAST_WEEK", "FILE_MODIFIED_IN_LAST_MONTH", "getFILE_MODIFIED_IN_LAST_MONTH", "intellij.searchEverywhereMl.ranking.yaml"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        private static final BooleanEventField KEY_IS_MOST_RECENTLY_USED = EventFields.Boolean((String)"yamlKeyIsMostRecentlyUsed");
        @NotNull
        private static final BooleanEventField KEY_IS_IN_TOP_5_RECENTLY_USED = EventFields.Boolean((String)"yamlKeyIsInTop5RecentlyUsed");
        @NotNull
        private static final BooleanEventField KEY_NEVER_USED = EventFields.Boolean((String)"yamlKeyNeverUsed");
        @NotNull
        private static final BooleanEventField KEY_IS_MOST_POPULAR = EventFields.Boolean((String)"yamlKeyIsMostPopular");
        @NotNull
        private static final IntEventField FILE_RECENCY_INDEX = EventFields.Int((String)"yamlFileRecencyIndex");
        @NotNull
        private static final LongEventField FILE_TIME_SINCE_LAST_MODIFICATION = EventFields.Long$default((String)"yamlTimeSinceLastModification", null, (int)2, null);
        @NotNull
        private static final BooleanEventField FILE_MODIFIED_IN_LAST_HOUR = EventFields.Boolean((String)"yamlFileModifiedInLastHour");
        @NotNull
        private static final BooleanEventField FILE_MODIFIED_IN_LAST_DAY = EventFields.Boolean((String)"yamlFileModifiedInLastDay");
        @NotNull
        private static final BooleanEventField FILE_MODIFIED_IN_LAST_WEEK = EventFields.Boolean((String)"yamlFileModifiedInLastWeek");
        @NotNull
        private static final BooleanEventField FILE_MODIFIED_IN_LAST_MONTH = EventFields.Boolean((String)"yamlFileModifiedInLastMonth");

        private Fields() {
        }

        @NotNull
        public final BooleanEventField getKEY_IS_MOST_RECENTLY_USED() {
            return KEY_IS_MOST_RECENTLY_USED;
        }

        @NotNull
        public final BooleanEventField getKEY_IS_IN_TOP_5_RECENTLY_USED() {
            return KEY_IS_IN_TOP_5_RECENTLY_USED;
        }

        @NotNull
        public final BooleanEventField getKEY_NEVER_USED() {
            return KEY_NEVER_USED;
        }

        @NotNull
        public final BooleanEventField getKEY_IS_MOST_POPULAR() {
            return KEY_IS_MOST_POPULAR;
        }

        @NotNull
        public final IntEventField getFILE_RECENCY_INDEX() {
            return FILE_RECENCY_INDEX;
        }

        @NotNull
        public final LongEventField getFILE_TIME_SINCE_LAST_MODIFICATION() {
            return FILE_TIME_SINCE_LAST_MODIFICATION;
        }

        @NotNull
        public final BooleanEventField getFILE_MODIFIED_IN_LAST_HOUR() {
            return FILE_MODIFIED_IN_LAST_HOUR;
        }

        @NotNull
        public final BooleanEventField getFILE_MODIFIED_IN_LAST_DAY() {
            return FILE_MODIFIED_IN_LAST_DAY;
        }

        @NotNull
        public final BooleanEventField getFILE_MODIFIED_IN_LAST_WEEK() {
            return FILE_MODIFIED_IN_LAST_WEEK;
        }

        @NotNull
        public final BooleanEventField getFILE_MODIFIED_IN_LAST_MONTH() {
            return FILE_MODIFIED_IN_LAST_MONTH;
        }
    }
}

