/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CommonTestInjection;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.AdminHandlersProxy;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.PrometheusResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.stats.MetricUtils;

public class MetricsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    final SolrMetricManager metricManager;
    public static final String COMPACT_PARAM = "compact";
    public static final String PREFIX_PARAM = "prefix";
    public static final String REGEX_PARAM = "regex";
    public static final String PROPERTY_PARAM = "property";
    public static final String REGISTRY_PARAM = "registry";
    public static final String GROUP_PARAM = "group";
    public static final String KEY_PARAM = "key";
    public static final String EXPR_PARAM = "expr";
    public static final String TYPE_PARAM = "type";
    public static final String PROMETHEUS_METRICS_WT = "prometheus";
    public static final String ALL = "all";
    private static final Pattern KEY_SPLIT_REGEX = Pattern.compile("(?<!" + Pattern.quote("\\") + ")" + Pattern.quote(":"));
    private final CoreContainer cc;
    private final Map<String, String> injectedSysProps = CommonTestInjection.injectAdditionalProps();
    private final boolean enabled;

    public MetricsHandler(CoreContainer coreContainer) {
        this.metricManager = coreContainer.getMetricManager();
        this.cc = coreContainer;
        this.enabled = coreContainer.getConfig().getMetricsConfig().isEnabled();
    }

    public MetricsHandler(SolrMetricManager metricManager) {
        this.metricManager = metricManager;
        this.cc = null;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_READ_PERM;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        if (this.metricManager == null) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "SolrMetricManager instance not initialized");
        }
        if (this.cc != null && AdminHandlersProxy.maybeProxyToNodes(req, rsp, this.cc)) {
            return;
        }
        SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
        try {
            this.handleRequest(req.getParams(), (String k, Object v) -> rsp.add((String)k, v));
        }
        finally {
            SolrRequestInfo.clearRequestInfo();
        }
    }

    private void handleRequest(SolrParams params, BiConsumer<String, Object> consumer) {
        if (!this.enabled) {
            consumer.accept("error", "metrics collection is disabled");
            return;
        }
        if (PROMETHEUS_METRICS_WT.equals(params.get("wt"))) {
            NamedList<Object> response = this.handlePrometheusExport(params);
            consumer.accept("metrics", response);
            return;
        }
        String[] keys = params.getParams(KEY_PARAM);
        if (keys != null && keys.length > 0) {
            this.handleKeyRequest(keys, consumer);
            return;
        }
        String[] exprs = params.getParams(EXPR_PARAM);
        if (exprs != null && exprs.length > 0) {
            this.handleExprRequest(exprs, consumer);
            return;
        }
        NamedList<Object> response = this.handleDropwizardRegistry(params);
        consumer.accept("metrics", response);
    }

    private NamedList<Object> handleDropwizardRegistry(SolrParams params) {
        boolean compact = params.getBool(COMPACT_PARAM, true);
        MetricFilter mustMatchFilter = this.parseMustMatchFilter(params);
        Predicate<CharSequence> propertyFilter = this.parsePropertyFilter(params);
        List<MetricType> metricTypes = this.parseMetricTypes(params);
        List<MetricFilter> metricFilters = metricTypes.stream().map(MetricType::asMetricFilter).collect(Collectors.toList());
        Set<String> requestedRegistries = this.parseRegistries(params);
        SimpleOrderedMap response = new SimpleOrderedMap();
        for (String registryName : requestedRegistries) {
            MetricRegistry registry = this.metricManager.registry(registryName);
            SimpleOrderedMap result = new SimpleOrderedMap();
            MetricUtils.toMaps(registry, metricFilters, mustMatchFilter, propertyFilter, false, false, compact, false, (k, v) -> result.add(k, v));
            if (result.size() <= 0) continue;
            response.add(registryName, (Object)result);
        }
        return response;
    }

    private NamedList<Object> handlePrometheusExport(SolrParams params) {
        SimpleOrderedMap response = new SimpleOrderedMap();
        MetricFilter mustMatchFilter = this.parseMustMatchFilter(params);
        Predicate<CharSequence> propertyFilter = this.parsePropertyFilter(params);
        List<MetricType> metricTypes = this.parseMetricTypes(params);
        List<MetricFilter> metricFilters = metricTypes.stream().map(MetricType::asMetricFilter).collect(Collectors.toList());
        Set<String> requestedRegistries = this.parseRegistries(params);
        for (String registryName : requestedRegistries) {
            MetricRegistry dropwizardRegistry = this.metricManager.registry(registryName);
            PrometheusResponseWriter.toPrometheus(dropwizardRegistry, registryName, metricFilters, mustMatchFilter, propertyFilter, false, false, true, arg_0 -> MetricsHandler.lambda$handlePrometheusExport$2((NamedList)response, registryName, arg_0));
        }
        return response;
    }

    private void handleExprRequest(String[] exprs, BiConsumer<String, Object> consumer) {
        SimpleOrderedMap result = new SimpleOrderedMap();
        SimpleOrderedMap errors = new SimpleOrderedMap();
        ArrayList<MetricsExpr> metricsExprs = new ArrayList<MetricsExpr>();
        for (String key : exprs) {
            if (key == null || key.isEmpty()) continue;
            String[] parts = KEY_SPLIT_REGEX.split(key);
            if (parts.length < 2 || parts.length > 3) {
                errors.add(key, (Object)"at least two and at most three colon-separated parts must be provided");
                continue;
            }
            MetricsExpr me2 = new MetricsExpr();
            me2.registryRegex = Pattern.compile(MetricsHandler.unescape(parts[0]));
            me2.metricFilter = new SolrMetricManager.RegexFilter(MetricsHandler.unescape(parts[1]));
            final String propertyPart = parts.length > 2 ? MetricsHandler.unescape(parts[2]) : null;
            me2.propertyFilter = propertyPart == null ? name -> true : new Predicate<CharSequence>(){
                final Pattern pattern;
                {
                    this.pattern = Pattern.compile(propertyPart);
                }

                @Override
                public boolean test(CharSequence charSequence) {
                    return this.pattern.matcher(charSequence).matches();
                }
            };
            metricsExprs.add(me2);
        }
        TreeSet matchingRegistries = new TreeSet();
        metricsExprs.forEach(me -> this.metricManager.registryNames().forEach(name -> {
            if (me.registryRegex.matcher((CharSequence)name).matches()) {
                matchingRegistries.add(name);
            }
        }));
        for (String registryName : matchingRegistries) {
            MetricRegistry registry = this.metricManager.registry(registryName);
            for (MetricsExpr me2 : metricsExprs) {
                SimpleOrderedMap perRegistryResult = (SimpleOrderedMap)result.get(registryName);
                SimpleOrderedMap perRegistryTemp = new SimpleOrderedMap();
                if (!me2.registryRegex.matcher(registryName).matches()) continue;
                MetricUtils.toMaps(registry, Collections.singletonList(MetricFilter.ALL), me2.metricFilter, me2.propertyFilter, false, false, true, false, (k, v) -> perRegistryTemp.add(k, v));
                if (perRegistryTemp.size() <= 0) continue;
                if (perRegistryResult == null) {
                    result.add(registryName, (Object)perRegistryTemp);
                    continue;
                }
                for (Map.Entry entry : perRegistryTemp) {
                    Object existing = perRegistryResult.get((String)entry.getKey());
                    if (existing != null) continue;
                    perRegistryResult.add((String)entry.getKey(), entry.getValue());
                }
            }
        }
        consumer.accept("metrics", result);
        if (errors.size() > 0) {
            consumer.accept("errors", errors);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleKeyRequest(String[] keys, BiConsumer<String, Object> consumer) {
        SimpleOrderedMap result = new SimpleOrderedMap();
        SimpleOrderedMap errors = new SimpleOrderedMap();
        for (String string : keys) {
            void var8_8;
            String propertyName;
            if (string == null || string.isEmpty()) continue;
            String[] parts = KEY_SPLIT_REGEX.split(string);
            if (parts.length < 2 || parts.length > 3) {
                errors.add(string, (Object)"at least two and at most three colon-separated parts must be provided");
                continue;
            }
            String registryName = MetricsHandler.unescape(parts[0]);
            String metricName = MetricsHandler.unescape(parts[1]);
            String string2 = propertyName = parts.length > 2 ? MetricsHandler.unescape(parts[2]) : null;
            if (!this.metricManager.hasRegistry(registryName)) {
                errors.add(string, (Object)("registry '" + registryName + "' not found"));
                continue;
            }
            MetricRegistry registry = this.metricManager.registry(registryName);
            Metric m = (Metric)registry.getMetrics().get(metricName);
            if (m == null) {
                errors.add(string, (Object)("metric '" + metricName + "' not found"));
                continue;
            }
            Predicate<CharSequence> propertyFilter = MetricUtils.ALL_PROPERTIES;
            if (propertyName != null) {
                propertyFilter = propertyName::contentEquals;
                String string3 = parts[0] + ":" + parts[1];
            }
            if (this.injectedSysProps != null && SolrMetricManager.JVM_REGISTRY.equals(registryName) && "system.properties".equals(metricName) && this.injectedSysProps.containsKey(propertyName)) {
                result.add(registryName + ":" + metricName + ":" + propertyName, (Object)this.injectedSysProps.get(propertyName));
                continue;
            }
            MetricUtils.convertMetric((String)var8_8, m, propertyFilter, false, true, true, false, ":", (k, v) -> {
                if (v instanceof Map && propertyName != null) {
                    ((Map)v).forEach((k1, v1) -> result.add(k + ":" + k1, v1));
                } else if (v instanceof MapWriter && propertyName != null) {
                    ((MapWriter)v)._forEachEntry((k1, v1) -> result.add(k + ":" + k1, v1));
                } else {
                    result.add(k, v);
                }
            });
        }
        consumer.accept("metrics", result);
        if (errors.size() > 0) {
            consumer.accept("errors", errors);
        }
    }

    private static String unescape(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < s.length() - 1 && s.charAt(i + 1) == ':') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private MetricFilter parseMustMatchFilter(SolrParams params) {
        String[] prefixes = params.getParams(PREFIX_PARAM);
        SolrMetricManager.PrefixFilter prefixFilter = null;
        if (prefixes != null && prefixes.length > 0) {
            HashSet<String> prefixSet = new HashSet<String>();
            for (String prefix : prefixes) {
                prefixSet.addAll(StrUtils.splitSmart((String)prefix, (char)','));
            }
            prefixFilter = new SolrMetricManager.PrefixFilter(prefixSet);
        }
        String[] regexes = params.getParams(REGEX_PARAM);
        SolrMetricManager.RegexFilter regexFilter = null;
        if (regexes != null && regexes.length > 0) {
            regexFilter = new SolrMetricManager.RegexFilter(regexes);
        }
        Object mustMatchFilter = prefixFilter == null && regexFilter == null ? MetricFilter.ALL : (prefixFilter == null ? regexFilter : (regexFilter == null ? prefixFilter : new SolrMetricManager.OrFilter(prefixFilter, regexFilter)));
        return mustMatchFilter;
    }

    private Predicate<CharSequence> parsePropertyFilter(SolrParams params) {
        String[] props = params.getParams(PROPERTY_PARAM);
        if (props == null || props.length == 0) {
            return MetricUtils.ALL_PROPERTIES;
        }
        HashSet<String> filter = new HashSet<String>();
        for (String prop : props) {
            if (prop == null || prop.trim().isEmpty()) continue;
            filter.add(prop.trim());
        }
        if (filter.isEmpty()) {
            return MetricUtils.ALL_PROPERTIES;
        }
        return name -> filter.contains(name.toString());
    }

    private Set<String> parseRegistries(SolrParams params) {
        String[] groupStr = params.getParams(GROUP_PARAM);
        String[] registryStr = params.getParams(REGISTRY_PARAM);
        return this.parseRegistries(groupStr, registryStr);
    }

    public Set<String> parseRegistries(String[] groupStr, String[] registryStr) {
        List split;
        if (!(groupStr != null && groupStr.length != 0 || registryStr != null && registryStr.length != 0)) {
            return this.metricManager.registryNames();
        }
        boolean allRegistries = false;
        Set<String> initialPrefixes = Collections.emptySet();
        if (groupStr != null && groupStr.length > 0) {
            initialPrefixes = new HashSet<String>();
            for (String g : groupStr) {
                split = StrUtils.splitSmart((String)g, (char)',');
                for (String s : split) {
                    if (s.trim().equals(ALL)) {
                        allRegistries = true;
                        break;
                    }
                    initialPrefixes.add(SolrMetricManager.enforcePrefix(s.trim()));
                }
                if (!allRegistries) continue;
                return this.metricManager.registryNames();
            }
        }
        if (registryStr != null && registryStr.length > 0) {
            if (initialPrefixes.isEmpty()) {
                initialPrefixes = new HashSet<String>();
            }
            for (String r : registryStr) {
                split = StrUtils.splitSmart((String)r, (char)',');
                for (String s : split) {
                    if (s.trim().equals(ALL)) {
                        allRegistries = true;
                        break;
                    }
                    initialPrefixes.add(SolrMetricManager.enforcePrefix(s.trim()));
                }
                if (!allRegistries) continue;
                return this.metricManager.registryNames();
            }
        }
        HashSet<String> validRegistries = new HashSet<String>();
        block4: for (String r : this.metricManager.registryNames()) {
            for (String prefix : initialPrefixes) {
                if (!r.startsWith(prefix)) continue;
                validRegistries.add(r);
                continue block4;
            }
        }
        return validRegistries;
    }

    private List<MetricType> parseMetricTypes(SolrParams params) {
        String[] typeStr = params.getParams(TYPE_PARAM);
        List types = Collections.emptyList();
        if (typeStr != null && typeStr.length > 0) {
            types = new ArrayList();
            for (String type : typeStr) {
                types.addAll(StrUtils.splitSmart((String)type, (char)','));
            }
        }
        List<MetricType> metricTypes = Collections.singletonList(MetricType.all);
        try {
            if (types.size() > 0) {
                metricTypes = types.stream().map(String::trim).map(MetricType::valueOf).collect(Collectors.toList());
            }
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid metric type in: " + types + " specified. Must be one of " + MetricType.SUPPORTED_TYPES_MSG, (Throwable)e);
        }
        return metricTypes;
    }

    @Override
    public String getDescription() {
        return "A handler to return all the metrics gathered by Solr";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    private static /* synthetic */ void lambda$handlePrometheusExport$2(NamedList response, String registryName, SolrPrometheusFormatter registry) {
        response.add(registryName, (Object)registry);
    }

    static enum MetricType {
        histogram(Histogram.class),
        meter(Meter.class),
        timer(Timer.class),
        counter(Counter.class),
        gauge(Gauge.class),
        all(null);

        public static final String SUPPORTED_TYPES_MSG;
        private final Class<? extends Metric> klass;

        private MetricType(Class<? extends Metric> klass) {
            this.klass = klass;
        }

        public MetricFilter asMetricFilter() {
            return (name, metric) -> this.klass == null || this.klass.isInstance(metric);
        }

        static {
            SUPPORTED_TYPES_MSG = EnumSet.allOf(MetricType.class).toString();
        }
    }

    private static class MetricsExpr {
        Pattern registryRegex;
        MetricFilter metricFilter;
        Predicate<CharSequence> propertyFilter;

        private MetricsExpr() {
        }
    }
}

