/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElement;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElementF2m;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElementFp;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Point
implements Serializable {
    @XmlElements(value={@XmlElement(type=FieldElementF2m.class, name="xFieldElementF2m"), @XmlElement(type=FieldElementFp.class, name="xFieldElementFp")})
    private final FieldElement x;
    @XmlElements(value={@XmlElement(type=FieldElementF2m.class, name="yFieldElementF2m"), @XmlElement(type=FieldElementFp.class, name="yFieldElementFp")})
    private final FieldElement y;
    private final boolean infinity;

    public static Point createPoint(BigInteger x, BigInteger y, NamedGroup group) {
        EllipticCurve curve = CurveFactory.getCurve(group);
        return curve.getPoint(x, y);
    }

    public static Point createPoint(BigInteger x, BigInteger y, GOSTCurve group) {
        EllipticCurve curve = CurveFactory.getCurve(group);
        return curve.getPoint(x, y);
    }

    public Point() {
        this.infinity = true;
        this.x = null;
        this.y = null;
    }

    public Point(FieldElement x, FieldElement y) {
        this.x = x;
        this.y = y;
        this.infinity = false;
    }

    public boolean isAtInfinity() {
        return this.infinity;
    }

    public FieldElement getX() {
        return this.x;
    }

    public FieldElement getY() {
        return this.y;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.x);
        hash = 89 * hash + Objects.hashCode(this.y);
        hash = 89 * hash + (this.infinity ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.infinity != other.infinity) {
            return false;
        }
        if (!Objects.equals(this.x, other.x)) {
            return false;
        }
        return Objects.equals(this.y, other.y);
    }

    public String toString() {
        if (this.isAtInfinity()) {
            return "Point: Infinity";
        }
        return "Point: (" + this.getX().toString() + ", " + this.getY().toString() + ")";
    }
}

