/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.KeyShareExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.KeyShareExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.KeyShareExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareExtensionHandler
extends ExtensionHandler<KeyShareExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ExtensionType type;

    public KeyShareExtensionHandler(TlsContext context, ExtensionType type) {
        super(context);
        if (type != ExtensionType.KEY_SHARE && type != ExtensionType.KEY_SHARE_OLD) {
            throw new RuntimeException("Trying to initalize KeyShareExtensionHandler with an illegal ExtensionType");
        }
        this.type = type;
    }

    @Override
    public KeyShareExtensionParser getParser(byte[] message, int pointer) {
        return new KeyShareExtensionParser(pointer, message, this.type);
    }

    public KeyShareExtensionPreparator getPreparator(KeyShareExtensionMessage message) {
        return new KeyShareExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public KeyShareExtensionSerializer getSerializer(KeyShareExtensionMessage message) {
        return new KeyShareExtensionSerializer(message, this.context.getChooser().getConnectionEndType());
    }

    @Override
    public void adjustTLSExtensionContext(KeyShareExtensionMessage message) {
        LinkedList<KeyShareStoreEntry> ksEntryList = new LinkedList<KeyShareStoreEntry>();
        for (KeyShareEntry pair : message.getKeyShareList()) {
            NamedGroup type = NamedGroup.getNamedGroup((byte[])pair.getGroup().getValue());
            if (type != null) {
                if (pair.getPublicKey() != null && pair.getPublicKey().getValue() != null) {
                    ksEntryList.add(new KeyShareStoreEntry(type, (byte[])pair.getPublicKey().getValue()));
                    continue;
                }
                LOGGER.warn("Empty KeyShare - Setting only selected KeyShareType: to " + ArrayConverter.bytesToHexString((ModifiableByteArray)pair.getGroup()));
                this.context.setSelectedGroup(type);
                continue;
            }
            LOGGER.warn("Unknown KS Type:" + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getPublicKey().getValue())));
        }
        if (this.context.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            if (ksEntryList.size() > 0) {
                this.context.setServerKeyShareStoreEntry(new KeyShareStoreEntry(((KeyShareStoreEntry)ksEntryList.get(0)).getGroup(), ((KeyShareStoreEntry)ksEntryList.get(0)).getPublicKey()));
            }
        } else {
            this.context.setClientKeyShareStoreEntryList(ksEntryList);
        }
    }
}

