/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.connection.Aliasable;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class TlsAction
implements Serializable,
Aliasable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean EXECUTED_DEFAULT = false;
    private Boolean executed = null;
    @XmlTransient
    private Boolean singleConnectionWorkflow = true;
    @XmlTransient
    private final Set<String> aliases = new LinkedHashSet<String>();

    public boolean isExecuted() {
        if (this.executed == null) {
            return false;
        }
        return this.executed;
    }

    public void setExecuted(Boolean executed) {
        this.executed = executed;
    }

    public Boolean isSingleConnectionWorkflow() {
        return this.singleConnectionWorkflow;
    }

    public void setSingleConnectionWorkflow(Boolean singleConnectionWorkflow) {
        this.singleConnectionWorkflow = singleConnectionWorkflow;
    }

    public abstract void execute(State var1) throws WorkflowExecutionException;

    public abstract void reset();

    public void normalize() {
    }

    public void normalize(TlsAction defaultAction) {
    }

    public void filter() {
    }

    public void filter(TlsAction defaultAction) {
    }

    @Override
    public String getFirstAlias() {
        return this.getAllAliases().iterator().next();
    }

    @Override
    public boolean containsAllAliases(Collection<String> aliases) {
        return this.getAllAliases().containsAll(aliases);
    }

    @Override
    public boolean containsAlias(String alias) {
        return this.getAllAliases().contains(alias);
    }

    @Override
    public void assertAliasesSetProperly() throws ConfigurationException {
    }

    @Override
    public Set<String> getAllAliases() {
        return this.aliases;
    }

    public abstract boolean executedAsPlanned();

    public boolean isMessageAction() {
        return this instanceof MessageAction;
    }

    @Override
    public String aliasesToString() {
        StringBuilder sb = new StringBuilder();
        for (String alias : this.getAllAliases()) {
            sb.append(alias).append(",");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (!this.getAllAliases().isEmpty()) {
            sb.append(" [").append(this.aliasesToString()).append("]");
        }
        return sb.toString();
    }
}

