/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.ui;

import jadx.gui.settings.JadxSettings;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.ActionHandler;
import java.awt.Container;
import java.awt.Font;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ZoomActions {
    private final JComponent component;
    private final JadxSettings settings;
    private final Runnable update;

    public static void register(JComponent component, JadxSettings settings, Runnable update) {
        ZoomActions actions = new ZoomActions(component, settings, update);
        actions.register();
    }

    private ZoomActions(JComponent component, JadxSettings settings, Runnable update) {
        this.component = component;
        this.settings = settings;
        this.update = update;
    }

    private void register() {
        String zoomIn = "TextZoomIn";
        String zoomOut = "TextZoomOut";
        int ctrlButton = UiUtils.ctrlButton();
        InputMap inputMap = this.component.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(521, ctrlButton), zoomIn);
        inputMap.put(KeyStroke.getKeyStroke(61, ctrlButton), zoomIn);
        inputMap.put(KeyStroke.getKeyStroke(107, ctrlButton), zoomIn);
        inputMap.put(KeyStroke.getKeyStroke(45, ctrlButton), zoomOut);
        inputMap.put(KeyStroke.getKeyStroke(109, ctrlButton), zoomOut);
        ActionMap actionMap = this.component.getActionMap();
        actionMap.put(zoomIn, new ActionHandler(e -> this.textZoom(1)));
        actionMap.put(zoomOut, new ActionHandler(e -> this.textZoom(-1)));
        this.component.addMouseWheelListener(e -> {
            if (e.getModifiersEx() == UiUtils.ctrlButton()) {
                this.textZoom(e.getWheelRotation() < 0 ? 1 : -1);
                e.consume();
            } else {
                Container parent = this.component.getParent();
                if (parent != null) {
                    parent.dispatchEvent(e);
                }
            }
        });
    }

    private void textZoom(int change) {
        Font font = this.settings.getFont();
        if (this.component.getFont().equals(font)) {
            this.settings.setFont(this.changeFontSize(font, change));
        } else {
            this.settings.setSmaliFont(this.changeFontSize(this.settings.getSmaliFont(), change));
        }
        this.settings.sync();
        this.update.run();
    }

    private Font changeFontSize(Font font, int change) {
        float newSize = font.getSize() + change;
        if (newSize < 2.0f) {
            return font;
        }
        return font.deriveFont(newSize);
    }
}

