/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.JumpData;

public class BranchData
extends JumpData {
    static final int notTakenOffSet = 2;
    static final int branchCellCount = 3;

    public BranchData(DataLayout layout) {
        super(layout);
    }

    static int staticCellCount() {
        return 3;
    }

    @Override
    public int cellCount() {
        return BranchData.staticCellCount();
    }

    int notTaken() {
        return this.uintAt(2);
    }

    static int notTakenOffset() {
        return BranchData.cellOffset(2);
    }

    static int branchDataSize() {
        return BranchData.cellOffset(3);
    }

    @Override
    public void printDataOn(PrintStream st) {
        this.printShared(st, "BranchData");
        st.println("taken(" + this.taken() + ") displacement(" + this.displacement() + ")");
        this.tab(st);
        st.println("not taken(" + this.notTaken() + ")");
    }
}

