/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Finalizer;
import java.lang.ref.ReferenceQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

final class FinalizerHistogram {
    FinalizerHistogram() {
    }

    static Entry[] getFinalizerHistogram() {
        HashMap hashMap = new HashMap();
        ReferenceQueue<Object> referenceQueue = Finalizer.getQueue();
        referenceQueue.forEach(reference -> {
            Object t = reference.get();
            if (t != null) {
                hashMap.computeIfAbsent(t.getClass().getName(), Entry::new).increment();
                t = null;
            }
        });
        Entry[] entryArray = hashMap.values().toArray(new Entry[hashMap.size()]);
        Arrays.sort(entryArray, Comparator.comparingInt(Entry::getInstanceCount).reversed());
        return entryArray;
    }

    private static final class Entry {
        private int instanceCount;
        private final String className;

        int getInstanceCount() {
            return this.instanceCount;
        }

        void increment() {
            ++this.instanceCount;
        }

        Entry(String string) {
            this.className = string;
        }
    }
}

