/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;

public class ElementAttributes
implements IElementAttributes {
    private static final long serialVersionUID = 7814990748035017441L;
    private boolean IS_SPOOL = true;
    private boolean IS_LATERAL = true;
    private boolean IS_REMOTE = true;
    private boolean IS_ETERNAL = true;
    private long maxLife = -1L;
    private long maxIdleTime = -1L;
    private int size = 0;
    private long createTime = 0L;
    private long lastAccessTime = 0L;
    private transient ArrayList<IElementEventHandler> eventHandlers;
    private long timeFactor = 1000L;

    public ElementAttributes() {
        this.lastAccessTime = this.createTime = System.currentTimeMillis();
    }

    protected ElementAttributes(ElementAttributes attr) {
        this.IS_ETERNAL = attr.IS_ETERNAL;
        this.IS_SPOOL = attr.IS_SPOOL;
        this.IS_LATERAL = attr.IS_LATERAL;
        this.IS_REMOTE = attr.IS_REMOTE;
        this.maxLife = attr.maxLife;
        this.maxIdleTime = attr.maxIdleTime;
        this.size = attr.size;
    }

    @Override
    public void setMaxLife(long mls) {
        this.maxLife = mls;
    }

    @Override
    public long getMaxLife() {
        return this.maxLife;
    }

    @Override
    public void setIdleTime(long idle) {
        this.maxIdleTime = idle;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public long getIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public long getTimeToLiveSeconds() {
        long now = System.currentTimeMillis();
        long timeFactorForMilliseconds = this.getTimeFactorForMilliseconds();
        return (this.getCreateTime() + this.getMaxLife() * timeFactorForMilliseconds - now) / 1000L;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTimeNow() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void setLastAccessTime(long time) {
        this.lastAccessTime = time;
    }

    @Override
    public boolean getIsSpool() {
        return this.IS_SPOOL;
    }

    @Override
    public void setIsSpool(boolean val) {
        this.IS_SPOOL = val;
    }

    @Override
    public boolean getIsLateral() {
        return this.IS_LATERAL;
    }

    @Override
    public void setIsLateral(boolean val) {
        this.IS_LATERAL = val;
    }

    @Override
    public boolean getIsRemote() {
        return this.IS_REMOTE;
    }

    @Override
    public void setIsRemote(boolean val) {
        this.IS_REMOTE = val;
    }

    @Override
    public boolean getIsEternal() {
        return this.IS_ETERNAL;
    }

    @Override
    public void setIsEternal(boolean val) {
        this.IS_ETERNAL = val;
    }

    @Override
    public void addElementEventHandler(IElementEventHandler eventHandler) {
        if (this.eventHandlers == null) {
            this.eventHandlers = new ArrayList();
        }
        this.eventHandlers.add(eventHandler);
    }

    @Override
    public void addElementEventHandlers(List<IElementEventHandler> eventHandlers) {
        if (eventHandlers == null) {
            return;
        }
        for (IElementEventHandler handler : eventHandlers) {
            this.addElementEventHandler(handler);
        }
    }

    @Override
    public long getTimeFactorForMilliseconds() {
        return this.timeFactor;
    }

    @Override
    public void setTimeFactorForMilliseconds(long factor) {
        this.timeFactor = factor;
    }

    @Override
    public ArrayList<IElementEventHandler> getElementEventHandlers() {
        return this.eventHandlers;
    }

    public String toString() {
        StringBuilder dump = new StringBuilder();
        dump.append("[ IS_LATERAL = ").append(this.IS_LATERAL);
        dump.append(", IS_SPOOL = ").append(this.IS_SPOOL);
        dump.append(", IS_REMOTE = ").append(this.IS_REMOTE);
        dump.append(", IS_ETERNAL = ").append(this.IS_ETERNAL);
        dump.append(", MaxLifeSeconds = ").append(this.getMaxLife());
        dump.append(", IdleTime = ").append(this.getIdleTime());
        dump.append(", CreateTime = ").append(this.getCreateTime());
        dump.append(", LastAccessTime = ").append(this.getLastAccessTime());
        dump.append(", getTimeToLiveSeconds() = ").append(String.valueOf(this.getTimeToLiveSeconds()));
        dump.append(", createTime = ").append(String.valueOf(this.createTime)).append(" ]");
        return dump.toString();
    }

    @Override
    public IElementAttributes clone() {
        try {
            ElementAttributes c = (ElementAttributes)super.clone();
            c.setCreateTime();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported. This should never happen.", e);
        }
    }
}

