/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.DataQuery;
import com.ca.directory.jxplorer.broker.Broker;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class OfflineBroker
extends Broker {
    Hashtable nodes;
    Component display;
    private static Logger log = Logger.getLogger(OfflineBroker.class.getName());

    public OfflineBroker(Component graphicsDisplay) {
        this.display = graphicsDisplay;
        this.nodes = new Hashtable(1000);
    }

    public void clear() {
        this.nodes.clear();
    }

    public DXNamingEnumeration children(DN nodeDN) {
        Node N = (Node)this.nodes.get(nodeDN.toString());
        return N == null ? null : N.getChildren();
    }

    public boolean isActive() {
        return true;
    }

    public boolean hasData() {
        return !this.nodes.isEmpty();
    }

    public Vector objectClasses() {
        return null;
    }

    public Vector recommendedObjectClasses(DN dn) {
        return null;
    }

    public SchemaOps getSchemaOps() {
        return null;
    }

    protected boolean addNode(DXEntry entry) {
        DN nodeDN = entry.getDN();
        log.fine("adding node " + nodeDN);
        Node N = new Node(entry);
        this.nodes.put(nodeDN.toString(), N);
        Node P = N.getParent();
        if (P == null && nodeDN.size() > 1) {
            this.addNode(new DXEntry(new DXAttributes(new DXAttribute("structuralTreeNode", "true")), nodeDN.parentDN()));
            P = (Node)this.nodes.get(nodeDN.parentDN().toString());
        }
        log.fine("parent = " + (P == null ? "null" : P.toString()));
        if (P != null) {
            P.addChild(N);
        }
        return true;
    }

    public boolean updateNode(DXEntry oldSet, DXEntry newSet) {
        log.fine("offline cache updating " + oldSet.getDN().toString());
        Node N = (Node)this.nodes.get(oldSet.getDN().toString());
        if (N == null) {
            return false;
        }
        N.updateAttributes(newSet);
        return true;
    }

    public boolean deleteTree(DN nodeDN) {
        log.fine("offline cache deleting " + nodeDN.toString());
        Node N = (Node)this.nodes.get(nodeDN.toString());
        if (N == null) {
            return false;
        }
        NamingEnumeration children = N.getChildNodes();
        while (children.hasMoreElements()) {
            this.deleteTree(((Node)children.nextElement()).getDN());
        }
        this.nodes.remove(nodeDN.toString());
        Node parent = N.getParent();
        if (parent != null) {
            parent.removeChild(N);
        }
        return true;
    }

    public void move(DN oldNodeDN, DN newNodeDN) throws NamingException {
        this.unthreadedCopy(oldNodeDN, newNodeDN);
        this.deleteTree(oldNodeDN);
    }

    public boolean isModifiable() {
        return true;
    }

    public DirContext getDirContext() {
        return null;
    }

    public DataQuery doListQuery(DataQuery request) {
        request.setEnum(this.children(request.requestDN()));
        return request;
    }

    public DataQuery doSearchQuery(DataQuery request) {
        request.setException(new Exception("offline searches not allowed"));
        return request;
    }

    public DataQuery doGetAllOCsQuery(DataQuery request) {
        request.setException(new Exception("offline object class list not implemented"));
        return request;
    }

    public DataQuery doGetRecOCsQuery(DataQuery request) {
        request.setException(new Exception("offline object class list not implemented"));
        return request;
    }

    public DXNamingEnumeration unthreadedList(DN searchbase) {
        return this.children(searchbase);
    }

    public DXNamingEnumeration unthreadedSearch(DN dn, String filter, int search_level, String[] returnAttributes) {
        return null;
    }

    public void unthreadedCopy(DN oldNodeDN, DN newNodeDN) throws NamingException {
        Node Old = (Node)this.nodes.get(oldNodeDN.toString());
        if (Old == null) {
            throw new NamingException("null old dn passed to unthreaded copy");
        }
        this.addNode(new DXEntry(Old.getEntry(), newNodeDN));
        Node New = (Node)this.nodes.get(newNodeDN.toString());
        NamingEnumeration children = Old.getChildNodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            DN NewChildDN = new DN(New.getDN());
            NewChildDN.addChildRDN(child.getDN().getLowestRDN().toString());
            this.unthreadedCopy(child.getDN(), NewChildDN);
        }
    }

    public boolean unthreadedExists(DN nodeDN) {
        return this.nodes.containsKey(nodeDN.toString());
    }

    public Vector unthreadedGetAllOCs() {
        return null;
    }

    public DXEntry unthreadedReadEntry(DN entryDN, String[] returnAttributes) {
        Node N;
        if (returnAttributes != null) {
            log.info("warning: att list read entries not implemented in offline broker");
        }
        return (N = (Node)this.nodes.get(entryDN.toString())) == null ? new DXEntry(entryDN) : N.getEntry();
    }

    public void unthreadedModify(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        if (oldEntry != null || newEntry != null) {
            if (oldEntry == null) {
                this.addNode(newEntry);
            } else if (newEntry == null) {
                this.deleteTree(oldEntry.getDN());
            } else {
                RDN singleValRDN = oldEntry.getDN().getLowestRDN();
                String namingAtt = singleValRDN.getAtt();
                String namingVal = singleValRDN.getRawVal();
                oldEntry.remove(namingAtt);
                newEntry.remove(namingAtt);
                newEntry.put(new DXAttribute(namingAtt, namingVal));
                if (!oldEntry.getDN().equals(newEntry.getDN())) {
                    this.move(oldEntry.getDN(), newEntry.getDN());
                    oldEntry.putDN(newEntry.getDN());
                }
                this.updateNode(oldEntry, newEntry);
            }
        }
    }

    public ArrayList unthreadedGetRecOCs(DN dn) {
        return null;
    }

    class Node {
        DXEntry entry;
        Vector children;
        DN dn;
        NameClassPair namePair;

        public Node(DXEntry entry) {
            this.entry = entry;
            this.dn = entry.getDN();
            this.children = new Vector(10);
            this.namePair = new NameClassPair(this.dn.getLowestRDN().toString(), this.dn.getLowestRDN().getAtt());
        }

        public void addChild(Node n) {
            this.children.add(n);
        }

        public void removeChild(Node n) {
            this.children.remove(n);
        }

        public void updateAttributes(DXAttributes a) {
            try {
                NamingEnumeration attset = a.getAll();
                while (attset.hasMore()) {
                    this.entry.put((Attribute)attset.next());
                }
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "unusual error in OfflineBroker::updateAttributes", e);
            }
        }

        public DXNamingEnumeration getChildren() {
            DXNamingEnumeration result = new DXNamingEnumeration();
            for (int i = 0; i < this.children.size(); ++i) {
                result.add(((Node)this.children.elementAt(i)).getNameClassPair());
            }
            return result;
        }

        public NamingEnumeration getChildNodes() {
            DXNamingEnumeration result = new DXNamingEnumeration();
            for (int i = 0; i < this.children.size(); ++i) {
                result.add(this.children.elementAt(i));
            }
            return result;
        }

        public NameClassPair getNameClassPair() {
            return this.namePair;
        }

        public DXEntry getEntry() {
            return this.entry;
        }

        public DN getDN() {
            return this.dn;
        }

        public Node getParent() {
            DN parentDN = this.dn.parentDN();
            if (parentDN == null) {
                return null;
            }
            Node Parent = (Node)OfflineBroker.this.nodes.get(parentDN.toString());
            return Parent;
        }

        public String toString() {
            return this.dn.toString();
        }
    }
}

