/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;
import org.keycloak.config.database.Database;

public class DatabaseOptions {
    public static final Option<String> DB_DIALECT = new OptionBuilder<String>("db-dialect", String.class).category(OptionCategory.DATABASE).hidden().buildTime(true).build();
    public static final Option<String> DB_DRIVER = new OptionBuilder<String>("db-driver", String.class).category(OptionCategory.DATABASE).description("The fully qualified class name of the JDBC driver. If not set, a default driver is set accordingly to the chosen database.").buildTime(true).build();
    public static final Option<String> DB = new OptionBuilder<String>("db", String.class).category(OptionCategory.DATABASE).description("The database vendor. In production mode the default value of 'dev-file' is deprecated, you should explicitly specify the db instead.").defaultValue("dev-file").expectedValues(Database.getDatabaseAliases()).buildTime(true).build();
    public static final Option<String> DB_URL = new OptionBuilder<String>("db-url", String.class).category(OptionCategory.DATABASE).description("The full database JDBC URL. If not provided, a default URL is set based on the selected database vendor. For instance, if using 'postgres', the default JDBC URL would be 'jdbc:postgresql://localhost/keycloak'. ").build();
    public static final Option<String> DB_URL_HOST = new OptionBuilder<String>("db-url-host", String.class).category(OptionCategory.DATABASE).description("Sets the hostname of the default JDBC URL of the chosen vendor. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<String> DB_URL_DATABASE = new OptionBuilder<String>("db-url-database", String.class).category(OptionCategory.DATABASE).description("Sets the database name of the default JDBC URL of the chosen vendor. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<Integer> DB_URL_PORT = new OptionBuilder<Integer>("db-url-port", Integer.class).category(OptionCategory.DATABASE).description("Sets the port of the default JDBC URL of the chosen vendor. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<String> DB_URL_PROPERTIES = new OptionBuilder<String>("db-url-properties", String.class).category(OptionCategory.DATABASE).description("Sets the properties of the default JDBC URL of the chosen vendor. Make sure to set the properties accordingly to the format expected by the database vendor, as well as appending the right character at the beginning of this property value. If the `db-url` option is set, this option is ignored.").build();
    public static final Option<String> DB_USERNAME = new OptionBuilder<String>("db-username", String.class).category(OptionCategory.DATABASE).description("The username of the database user.").build();
    public static final Option<String> DB_PASSWORD = new OptionBuilder<String>("db-password", String.class).category(OptionCategory.DATABASE).description("The password of the database user.").build();
    public static final Option<String> DB_SCHEMA = new OptionBuilder<String>("db-schema", String.class).category(OptionCategory.DATABASE).description("The database schema to be used.").build();
    public static final Option<Integer> DB_POOL_INITIAL_SIZE = new OptionBuilder<Integer>("db-pool-initial-size", Integer.class).category(OptionCategory.DATABASE).description("The initial size of the connection pool.").build();
    public static final Option<Integer> DB_POOL_MIN_SIZE = new OptionBuilder<Integer>("db-pool-min-size", Integer.class).category(OptionCategory.DATABASE).description("The minimal size of the connection pool.").build();
    public static final Option<Integer> DB_POOL_MAX_SIZE = new OptionBuilder<Integer>("db-pool-max-size", Integer.class).category(OptionCategory.DATABASE).defaultValue(100).description("The maximum size of the connection pool.").build();
    public static final Option<Boolean> DB_SQL_JPA_DEBUG = new OptionBuilder<Boolean>("db-debug-jpql", Boolean.class).category(OptionCategory.DATABASE).defaultValue(false).description("Add JPQL information as comments to SQL statements to debug JPA SQL statement generation.").build();
    public static final Option<Integer> DB_SQL_LOG_SLOW_QUERIES = new OptionBuilder<Integer>("db-log-slow-queries-threshold", Integer.class).category(OptionCategory.DATABASE).description("Log SQL statements slower than the configured threshold with logger org.hibernate.SQL_SLOW and log-level info.").defaultValue(10000).build();
    public static final Option<Boolean> DB_ACTIVE_DATASOURCE = new OptionBuilder<Boolean>("db-active-<datasource>", Boolean.class).category(OptionCategory.DATABASE_DATASOURCES).defaultValue(true).description("Deactivate specific named datasource <datasource>.").build();
    public static final List<Option<?>> OPTIONS_DATASOURCES = List.of(DB_DIALECT, DB_DRIVER, DB, DB_URL, DB_URL_HOST, DB_URL_DATABASE, DB_URL_PORT, DB_URL_PROPERTIES, DB_USERNAME, DB_PASSWORD, DB_SCHEMA, DB_POOL_INITIAL_SIZE, DB_POOL_MIN_SIZE, DB_POOL_MAX_SIZE);
    private static final Map<String, String> DATASOURCES_OVERRIDES_SUFFIX = Map.of(DB.getKey(), "-kind", DB_URL.getKey(), "-full");
    private static final Map<String, Option<?>> cachedDatasourceOptions = new HashMap();

    public static <T> Optional<Option<T>> getDatasourceOption(Option<T> parentOption) {
        if (!OPTIONS_DATASOURCES.contains(parentOption)) {
            return Optional.empty();
        }
        Optional<String> key = DatabaseOptions.getKeyForDatasource(parentOption);
        if (key.isEmpty()) {
            return Optional.empty();
        }
        Option<Object> option = cachedDatasourceOptions.get(key.get());
        if (option == null) {
            OptionBuilder<T> builder = parentOption.toBuilder().key(key.get()).category(OptionCategory.DATABASE_DATASOURCES);
            if (!parentOption.isHidden()) {
                builder.description("Used for named <datasource>. " + parentOption.getDescription());
            }
            option = builder.build();
            cachedDatasourceOptions.put(key.get(), option);
        }
        return Optional.of(option);
    }

    public static Optional<String> getKeyForDatasource(Option<?> option) {
        return DatabaseOptions.getKeyForDatasource(option.getKey());
    }

    public static Optional<String> getKeyForDatasource(String option) {
        return Optional.of(option).filter(o -> OPTIONS_DATASOURCES.stream().map(Option::getKey).anyMatch(o::equals)).map(key -> key.concat(DATASOURCES_OVERRIDES_SUFFIX.getOrDefault(key, ""))).map(key -> key.concat("-<datasource>"));
    }

    public static Optional<String> getResultNamedKey(Option<?> option, String namedProperty) {
        return DatabaseOptions.getKeyForDatasource(option).map(key -> key.substring(0, key.indexOf("<"))).map(key -> key.concat(namedProperty));
    }
}

