/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.oracle.runtime;

import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.pool.wrapper.ConnectionWrapper;
import java.sql.Connection;
import oracle.jdbc.OracleConnection;
import org.jboss.logging.Logger;

public class RollbackOnConnectionClosePoolInterceptor
implements AgroalPoolInterceptor {
    private static final Logger LOG = Logger.getLogger(RollbackOnConnectionClosePoolInterceptor.class);
    private final boolean noAutomaticRollback = Boolean.getBoolean("quarkus-oracle-no-automatic-rollback-on-connection-close");

    public void onConnectionDestroy(Connection connection) {
        ConnectionWrapper connectionWrapper;
        if (this.noAutomaticRollback) {
            return;
        }
        if (connection instanceof ConnectionWrapper && (connectionWrapper = (ConnectionWrapper)connection).getHandler().getXaResource() != null) {
            return;
        }
        try {
            Connection connection2 = connection.unwrap(Connection.class);
            if (connection2 instanceof OracleConnection) {
                OracleConnection oracleConnection = (OracleConnection)connection2;
                if (connection.isClosed() || connection.getAutoCommit()) {
                    return;
                }
                oracleConnection.rollback();
            }
        }
        catch (Exception e) {
            LOG.trace((Object)"Ignoring exception during rollback on connection close", (Throwable)e);
        }
    }
}

