/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics.timer;

import co.elastic.logstash.api.TimerMetric;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongSupplier;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.timer.TimerMetric;
import org.logstash.instrument.metrics.timer.Util;

public class ConcurrentLiveTimerMetric
extends AbstractMetric<Long>
implements TimerMetric {
    private final LongAdder untrackedMillis = new LongAdder();
    private final AtomicReference<TrackedMillisState> trackedMillisState;
    private final LongSupplier nanoTimeSupplier;

    protected ConcurrentLiveTimerMetric(String name) {
        this(name, System::nanoTime);
    }

    ConcurrentLiveTimerMetric(String name, LongSupplier nanoTimeSupplier) {
        super(name);
        this.nanoTimeSupplier = Objects.requireNonNullElse(nanoTimeSupplier, System::nanoTime);
        this.trackedMillisState = new AtomicReference<StaticTrackedMillisState>(new StaticTrackedMillisState());
    }

    @Override
    public <T, E extends Throwable> T time(TimerMetric.ExceptionalSupplier<T, E> exceptionalSupplier) throws E {
        try {
            this.trackedMillisState.getAndUpdate(TrackedMillisState::withIncrementedConcurrency);
            T t = exceptionalSupplier.get();
            return t;
        }
        finally {
            this.trackedMillisState.getAndUpdate(TrackedMillisState::withDecrementedConcurrency);
        }
    }

    @Override
    public void reportUntrackedMillis(long untrackedMillis) {
        this.untrackedMillis.add(untrackedMillis);
    }

    @Override
    public Long getValue() {
        return Math.addExact(this.getUntrackedMillis(), this.getTrackedMillis());
    }

    private long getUntrackedMillis() {
        return this.untrackedMillis.longValue();
    }

    private long getTrackedMillis() {
        return this.trackedMillisState.getAcquire().getValue();
    }

    private class StaticTrackedMillisState
    implements TrackedMillisState {
        private final long cumulativeMillis;
        private final int excessNanos;

        StaticTrackedMillisState(long cumulativeMillis, int excessNanos) {
            this.cumulativeMillis = cumulativeMillis;
            this.excessNanos = excessNanos;
        }

        public StaticTrackedMillisState() {
            this(0L, 0);
        }

        @Override
        public TrackedMillisState withIncrementedConcurrency() {
            return new DynamicTrackedMillisState(ConcurrentLiveTimerMetric.this.nanoTimeSupplier.getAsLong(), this.cumulativeMillis, this.excessNanos, 1);
        }

        @Override
        public TrackedMillisState withDecrementedConcurrency() {
            throw new IllegalStateException("TimerMetrics cannot track negative concurrency");
        }

        @Override
        public long getValue() {
            return this.cumulativeMillis;
        }
    }

    static interface TrackedMillisState {
        public TrackedMillisState withIncrementedConcurrency();

        public TrackedMillisState withDecrementedConcurrency();

        public long getValue();
    }

    private static enum Vector {
        INCREMENT{

            @Override
            int value() {
                return 1;
            }
        }
        ,
        DECREMENT{

            @Override
            int value() {
                return -1;
            }
        };


        abstract int value();
    }

    private class DynamicTrackedMillisState
    implements TrackedMillisState {
        private final long checkpointNanoTime;
        private final long millisAtCheckpoint;
        private final int excessNanosAtCheckpoint;
        private final int concurrencySinceCheckpoint;

        DynamicTrackedMillisState(long checkpointNanoTime, long millisAtCheckpoint, int excessNanosAtCheckpoint, int concurrencySinceCheckpoint) {
            this.checkpointNanoTime = checkpointNanoTime;
            this.millisAtCheckpoint = millisAtCheckpoint;
            this.excessNanosAtCheckpoint = excessNanosAtCheckpoint;
            this.concurrencySinceCheckpoint = concurrencySinceCheckpoint;
        }

        @Override
        public TrackedMillisState withIncrementedConcurrency() {
            return this.withAdjustedConcurrency(Vector.INCREMENT);
        }

        @Override
        public TrackedMillisState withDecrementedConcurrency() {
            return this.withAdjustedConcurrency(Vector.DECREMENT);
        }

        @Override
        public long getValue() {
            long nanoAdjustment = this.getNanoAdjustment(ConcurrentLiveTimerMetric.this.nanoTimeSupplier.getAsLong());
            long milliAdjustment = Util.wholeMillisFromNanos(nanoAdjustment);
            return Math.addExact(this.millisAtCheckpoint, milliAdjustment);
        }

        private TrackedMillisState withAdjustedConcurrency(Vector concurrencyAdjustmentVector) {
            int newConcurrency = Math.addExact(this.concurrencySinceCheckpoint, concurrencyAdjustmentVector.value());
            long newCheckpointNanoTime = ConcurrentLiveTimerMetric.this.nanoTimeSupplier.getAsLong();
            long totalNanoAdjustment = this.getNanoAdjustment(newCheckpointNanoTime);
            long newCheckpointMillis = Math.addExact(this.millisAtCheckpoint, Util.wholeMillisFromNanos(totalNanoAdjustment));
            int newCheckpointExcessNanos = Util.subMilliExcessNanos(totalNanoAdjustment);
            if (newConcurrency <= 0) {
                return new StaticTrackedMillisState(newCheckpointMillis, newCheckpointExcessNanos);
            }
            return new DynamicTrackedMillisState(newCheckpointNanoTime, newCheckpointMillis, newCheckpointExcessNanos, newConcurrency);
        }

        private long getNanoAdjustment(long checkpointNanoTime) {
            long deltaNanoTime = Math.subtractExact(checkpointNanoTime, this.checkpointNanoTime);
            long calculatedNanoAdjustment = Math.multiplyExact(deltaNanoTime, this.concurrencySinceCheckpoint);
            return Math.addExact(calculatedNanoAdjustment, (long)this.excessNanosAtCheckpoint);
        }
    }
}

