/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.api.ui.support;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DisplayNameListCellRenderer<T>
implements ListCellRenderer<T> {
    final ListCellRenderer<T> delegate;

    public DisplayNameListCellRenderer(ListCellRenderer<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp = this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null && comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            try {
                Method getDisplayName = value.getClass().getMethod("getDisplayName", new Class[0]);
                Object dn = getDisplayName.invoke(value, new Object[0]);
                if (dn != null) {
                    label.setText(dn.toString());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return comp;
    }
}

