/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.DecoratorsModel;
import org.netbeans.modules.web.beans.navigation.actions.ModelActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.filesystems.FileObject;

public final class DecoratoresActionStrategy
implements ModelActionStrategy {
    @Override
    public boolean isApplicable(ModelActionStrategy.InspectActionId id) {
        return id == ModelActionStrategy.InspectActionId.CLASS_CONTEXT;
    }

    @Override
    public boolean isApplicable(WebBeansModel model, Object[] context) {
        Object handle = context[0];
        if (handle == null) {
            return false;
        }
        Element element = ((ElementHandle)handle).resolve((CompilationInfo)model.getCompilationController());
        if (element == null) {
            return false;
        }
        List<AnnotationMirror> qualifiers = model.getQualifiers(element, true);
        if (qualifiers.size() > 0) {
            return true;
        }
        return model.getInterceptorBindings(element).isEmpty();
    }

    @Override
    public void invokeModelAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, final Object[] subject, JTextComponent component, FileObject fileObject) {
        Object handle = subject[0];
        Element element = ((ElementHandle)handle).resolve((CompilationInfo)model.getCompilationController());
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement type = (TypeElement)element;
        CompilationController controller = model.getCompilationController();
        Collection<TypeElement> decorators = model.getDecorators(type);
        BeansModel beansModel = model.getModelImplementation().getBeansModel();
        final DecoratorsModel uiModel = new DecoratorsModel(decorators, beansModel, controller, metaModel);
        final String name = type.getSimpleName().toString();
        if (SwingUtilities.isEventDispatchThread()) {
            WebBeansActionHelper.showDecoratorsDialog(metaModel, model, subject, uiModel, name);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBeansActionHelper.showDecoratorsDialog((MetadataModel<WebBeansModel>)metaModel, null, subject, uiModel, name);
                }
            });
        }
    }
}

