/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class UnitTestForSourceQueryImpl
implements MultipleRootsUnitTestForSourceQueryImplementation {
    private final JDKProject prj;

    public UnitTestForSourceQueryImpl(JDKProject prj) {
        this.prj = prj;
    }

    public URL[] findUnitTests(FileObject source) {
        Set<FileObject> roots = this.getRoots("jdk-project-sources-tests");
        if (!this.insideAnyRoot(roots, source)) {
            return this.toURLs(roots);
        }
        return null;
    }

    public URL[] findSources(FileObject unitTest) {
        Set<FileObject> roots = this.getRoots("java");
        roots.removeAll(this.getRoots("jdk-project-sources-tests"));
        if (!this.insideAnyRoot(roots, unitTest)) {
            return this.toURLs(roots);
        }
        return null;
    }

    private Set<FileObject> getRoots(String type) {
        SourceGroup[] groups = ProjectUtils.getSources((Project)this.prj).getSourceGroups(type);
        return Arrays.stream(groups).map(sg -> sg.getRootFolder()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean insideAnyRoot(Set<FileObject> roots, FileObject toTest) {
        return roots.stream().anyMatch(root -> FileUtil.isParentOf((FileObject)root, (FileObject)toTest) || root == toTest);
    }

    private URL[] toURLs(Set<FileObject> roots) {
        return (URL[])roots.stream().map(f -> f.toURL()).toArray(URL[]::new);
    }
}

