/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.validation.adapters;

import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;

public class WizardDescriptorAdapter
implements ValidationUI {
    private final WizardDescriptor wiz;
    private final Type type;

    public WizardDescriptorAdapter(WizardDescriptor d) {
        this(d, Type.VALID_AND_MESSAGE);
    }

    public WizardDescriptorAdapter(WizardDescriptor d, Type type) {
        this.wiz = d;
        this.type = type;
    }

    @Override
    public void clearProblem() {
        if (this.type != Type.VALID) {
            this.wiz.putProperty("WizardPanel_errorMessage", null);
        }
        if (this.type != Type.MESSAGE) {
            this.wiz.setValid(true);
        }
    }

    @Override
    public void showProblem(Problem p) {
        switch (p.severity()) {
            case INFO: {
                if (this.type != Type.VALID) {
                    this.wiz.putProperty("WizardPanel_infoMessage", (Object)p.getMessage());
                }
                if (this.type == Type.MESSAGE) break;
                this.wiz.setValid(true);
                break;
            }
            case WARNING: {
                if (this.type != Type.VALID) {
                    this.wiz.putProperty("WizardPanel_warningMessage", (Object)p.getMessage());
                }
                if (this.type == Type.MESSAGE) break;
                this.wiz.setValid(true);
                break;
            }
            case FATAL: {
                if (this.type != Type.VALID) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)p.getMessage());
                }
                if (this.type == Type.MESSAGE) break;
                this.wiz.setValid(false);
            }
        }
    }

    public static enum Type {
        VALID,
        MESSAGE,
        VALID_AND_MESSAGE;

    }
}

