/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.spi.tasklist.Task;
import org.openide.util.NbBundle;

class TaskListModel
extends AbstractTableModel
implements TaskList.Listener {
    protected TaskList taskList;
    protected static final int COL_GROUP = 0;
    protected static final int COL_DESCRIPTION = 1;
    protected static final int COL_FILE = 2;
    protected static final int COL_LOCATION = 3;
    private List<? extends Task> listOfTasks;
    protected int sortingCol = -1;
    protected boolean ascending = true;

    public TaskListModel(TaskList taskList) {
        this.taskList = taskList;
        this.listOfTasks = taskList.getTasks();
        this.sortingCol = Settings.getDefault().getSortingColumn();
        this.ascending = Settings.getDefault().isAscendingSort();
        this.sortTaskList();
    }

    @Override
    public int getRowCount() {
        return this.listOfTasks.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (0 == column) {
            return TaskGroup.class;
        }
        return super.getColumnClass(column);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "";
            }
            case 1: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Description");
            }
            case 2: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_File");
            }
            case 3: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Location");
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Task t = this.getTaskAtRow(row);
        if (null != t) {
            switch (col) {
                case 0: {
                    return Accessor.getGroup(t);
                }
                case 1: {
                    return Accessor.getDescription(t);
                }
                case 2: {
                    return Accessor.getFileNameExt(t);
                }
                case 3: {
                    return Accessor.getLocation(t);
                }
            }
        }
        return null;
    }

    protected Task getTaskAtRow(int row) {
        if (this.listOfTasks.size() > row) {
            return this.listOfTasks.get(row);
        }
        return null;
    }

    @Override
    public void tasksAdded(List<? extends Task> tasks) {
        if (!tasks.isEmpty()) {
            this.fireTasksChanged(true, tasks, this.listOfTasks, this.taskList.getTasks());
        }
    }

    @Override
    public void tasksRemoved(List<? extends Task> tasks) {
        if (!tasks.isEmpty()) {
            this.fireTasksChanged(false, tasks, this.listOfTasks, this.taskList.getTasks());
        }
    }

    private void fireTasksChanged(boolean add, List<? extends Task> changedTasks, List<? extends Task> oldList, List<? extends Task> newList) {
        EventQueue.invokeLater(() -> {
            List indexTaskList = add ? newList : oldList;
            int[] indices = new int[changedTasks.size()];
            for (int i = 0; i < changedTasks.size(); ++i) {
                indices[i] = indexTaskList.indexOf(changedTasks.get(i));
            }
            this.listOfTasks = newList;
            Arrays.sort(indices);
            int lastIdx = indices.length - 1;
            if (indices[0] < 0 || indices[lastIdx] - indices[0] + 1 != indices.length) {
                this.fireTableDataChanged();
            } else if (add) {
                this.fireTableRowsInserted(indices[0], indices[lastIdx]);
            } else {
                this.fireTableRowsDeleted(indices[0], indices[lastIdx]);
            }
        });
    }

    @Override
    public void cleared() {
        EventQueue.invokeLater(() -> {
            this.listOfTasks = this.taskList.getTasks();
            this.fireTableDataChanged();
        });
    }

    public void toggleSort(int column) {
        if (column != this.sortingCol) {
            this.sortingCol = column;
            this.ascending = true;
        } else if (this.ascending) {
            this.ascending = false;
        } else {
            this.sortingCol = -1;
        }
        this.sortTaskList();
    }

    protected void sortTaskList() {
        Comparator<Task> comparator;
        switch (this.sortingCol) {
            case 1: {
                comparator = TaskComparator.getDescriptionComparator(this.ascending);
                break;
            }
            case 3: {
                comparator = TaskComparator.getLocationComparator(this.ascending);
                break;
            }
            case 2: {
                comparator = TaskComparator.getFileComparator(this.ascending);
                break;
            }
            default: {
                comparator = TaskComparator.getDefault();
            }
        }
        this.taskList.setComparator(comparator);
        this.listOfTasks = this.taskList.getTasks();
        Settings.getDefault().setSortingColumn(this.sortingCol);
        Settings.getDefault().setAscendingSort(this.ascending);
        this.fireTableDataChanged();
    }

    public int getSortingColumnn() {
        return this.sortingCol;
    }

    public boolean isAscendingSort() {
        return this.ascending;
    }

    public void setAscendingSort(boolean asc) {
        if (this.sortingCol >= 0) {
            this.ascending = asc;
            this.sortTaskList();
        }
    }

    void attach() {
        this.taskList.addListener(this);
    }

    void detach() {
        this.taskList.removeListener(this);
    }
}

