/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.css.visual.api.RuleEditorController;
import org.netbeans.modules.css.visual.spi.CssStylesPanelProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class CssStylesPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(CssStylesPanel.class);
    static final boolean AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private final RuleEditorController controller;
    private final Collection<CssStylesPanelProvider> providers;
    private final ActionListener toolbarListener;
    private final ModifiableLookup providersLookup;
    private final ModifiableLookup tcLookup;
    private final JToolBar toolBar;
    private CssStylesPanelProvider active;
    private JComponent activePanel;
    private Map<String, CssStylesPanelProvider> selectedTabs = new HashMap<String, CssStylesPanelProvider>();
    private Border buttonBorder = null;
    private JSplitPane splitPane;
    private JPanel topPanel;

    public CssStylesPanel() {
        this.initComponents();
        this.tcLookup = new ModifiableLookup();
        this.providersLookup = new ModifiableLookup();
        this.providers = new ArrayList<CssStylesPanelProvider>();
        for (CssStylesPanelProvider provider : Lookup.getDefault().lookupAll(CssStylesPanelProvider.class)) {
            this.providers.add(new ProxyCssStylesPanelProvider(provider));
        }
        this.controller = RuleEditorController.createInstance();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CssStylesPanel.this.splitPane.setBottomComponent(CssStylesPanel.this.controller.getRuleEditorComponent());
            }
        });
        this.toolbarListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                for (CssStylesPanelProvider provider : CssStylesPanel.this.providers) {
                    if (!provider.getPanelID().equals(command)) continue;
                    FileObject file = (FileObject)CssStylesPanel.this.providersLookup.lookup(FileObject.class);
                    CssStylesPanel.this.selectedTabs.put(file.getMIMEType(), provider);
                    CssStylesPanel.this.setActiveProvider(provider);
                }
            }
        };
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.toolBar.setBorder(b);
        this.toolBar.setFocusable(true);
        if ("Windows".equals(UIManager.getLookAndFeel().getID()) && !CssStylesPanel.isXPTheme()) {
            this.toolBar.setRollover(true);
        } else if (AQUA) {
            this.toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.splitPane.setResizeWeight(0.66);
    }

    private Border getButtonBorder() {
        if (this.buttonBorder == null) {
            this.buttonBorder = UIManager.getBorder("nb.tabbutton.border");
        }
        return this.buttonBorder;
    }

    private static boolean isXPTheme() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return isXP == null ? false : isXP;
    }

    private JSplitPane createSplitPane() {
        return new JSplitPane(){

            @Override
            public String getUIClassID() {
                if (AQUA && UIManager.get("Nb.SplitPaneUI.clean") != null) {
                    return "Nb.SplitPaneUI.clean";
                }
                return super.getUIClassID();
            }
        };
    }

    public Lookup getLookup() {
        return this.tcLookup;
    }

    private Collection<CssStylesPanelProvider> getActiveProviders(FileObject file) {
        ArrayList<CssStylesPanelProvider> active = new ArrayList<CssStylesPanelProvider>();
        for (CssStylesPanelProvider provider : this.providers) {
            if (!provider.providesContentFor(file)) continue;
            active.add(provider);
        }
        return active;
    }

    private void addToolbar() {
        if (this.toolBar.getParent() == null) {
            this.topPanel.add((Component)this.toolBar, "First");
        }
    }

    private void removeToolbar() {
        if (this.toolBar.getParent() != null) {
            this.topPanel.remove(this.toolBar);
        }
    }

    private void updateToolbar(final FileObject file) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                final Collection activeProviders = CssStylesPanel.this.getActiveProviders(file);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CssStylesPanel.this.updateToolbar(file, activeProviders);
                    }
                });
            }
        });
    }

    private void updateToolbar(FileObject file, Collection<CssStylesPanelProvider> activeProviders) {
        this.toolBar.removeAll();
        if (activeProviders.size() <= 1) {
            this.removeToolbar();
        } else {
            this.addToolbar();
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean first = true;
        CssStylesPanelProvider selected = file == null ? null : this.selectedTabs.get(file.getMIMEType());
        boolean containsPreselected = selected == null ? false : activeProviders.contains(selected);
        for (CssStylesPanelProvider provider : activeProviders) {
            JToggleButton button = new JToggleButton();
            button.setText(provider.getPanelDisplayName());
            button.setActionCommand(provider.getPanelID());
            button.addActionListener(this.toolbarListener);
            button.setFocusable(true);
            button.setFocusPainted(false);
            button.setRolloverEnabled(true);
            Border b = this.getButtonBorder();
            if (b != null) {
                button.setBorder(b);
            }
            if (AQUA) {
                button.putClientProperty("JButton.buttonType", "square");
                button.putClientProperty("JComponent.sizeVariant", "small");
            }
            buttonGroup.add(button);
            this.toolBar.add(button);
            if (containsPreselected) {
                if (provider == selected) {
                    button.setSelected(true);
                    this.setActiveProvider(provider);
                    continue;
                }
                button.setSelected(false);
                continue;
            }
            button.setSelected(first);
            if (!first) continue;
            this.setActiveProvider(provider);
            first = false;
        }
        this.revalidate();
        this.repaint();
    }

    public void setContext(FileObject file) {
        InstanceContent ic = new InstanceContent();
        if (file != null) {
            ic.add((Object)file);
        }
        ic.add((Object)this.getRuleEditorController());
        this.providersLookup.updateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        this.updateToolbar(file);
    }

    private void setActiveProvider(CssStylesPanelProvider provider) {
        if (this.active == provider) {
            return;
        }
        if (this.active != null) {
            this.topPanel.remove(this.activePanel);
            this.active.deactivated();
        }
        this.active = provider;
        this.activePanel = provider.getContent((Lookup)this.providersLookup);
        this.topPanel.add((Component)this.activePanel, "Center");
        this.active.activated();
        this.tcLookup.updateLookup(this.active.getLookup());
        this.revalidate();
        this.repaint();
    }

    public RuleEditorController getRuleEditorController() {
        return this.controller;
    }

    private void initComponents() {
        this.splitPane = this.createSplitPane();
        this.topPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.splitPane.setDividerSize(4);
        this.splitPane.setOrientation(0);
        this.topPanel.setLayout(new BorderLayout());
        this.splitPane.setTopComponent(this.topPanel);
        this.add((Component)this.splitPane, "Center");
    }

    private static class ModifiableLookup
    extends ProxyLookup {
        private ModifiableLookup() {
        }

        protected final void updateLookup(Lookup lookup) {
            if (lookup == null) {
                this.setLookups(new Lookup[0]);
            } else {
                this.setLookups(new Lookup[]{lookup});
            }
        }
    }

    private static class ProxyCssStylesPanelProvider
    implements CssStylesPanelProvider {
        private final CssStylesPanelProvider delegate;
        private JComponent content;

        public ProxyCssStylesPanelProvider(CssStylesPanelProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getPanelID() {
            return this.delegate.getPanelID();
        }

        @Override
        public String getPanelDisplayName() {
            return this.delegate.getPanelDisplayName();
        }

        @Override
        public JComponent getContent(Lookup lookup) {
            if (this.content == null) {
                this.content = this.delegate.getContent(lookup);
            }
            return this.content;
        }

        @Override
        public Lookup getLookup() {
            return this.delegate.getLookup();
        }

        @Override
        public void activated() {
            this.delegate.activated();
        }

        @Override
        public void deactivated() {
            this.delegate.deactivated();
        }

        @Override
        public boolean providesContentFor(FileObject file) {
            return this.delegate.providesContentFor(file);
        }
    }
}

