/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.internal.util.StringUtil;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5Auth;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthReasonCode;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class MqttAuth
extends MqttMessageWithUserProperties.WithReason.WithCode<Mqtt5AuthReasonCode>
implements Mqtt5Auth {
    @NotNull
    private final MqttUtf8StringImpl method;
    @Nullable
    private final ByteBuffer data;

    public MqttAuth(@NotNull Mqtt5AuthReasonCode reasonCode, @NotNull MqttUtf8StringImpl method, @Nullable ByteBuffer data, @Nullable MqttUtf8StringImpl reasonString, @NotNull MqttUserPropertiesImpl userProperties) {
        super(reasonCode, reasonString, userProperties);
        this.method = method;
        this.data = data;
    }

    @Override
    @NotNull
    public MqttUtf8StringImpl getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public Optional<ByteBuffer> getData() {
        return ByteBufferUtil.optionalReadOnly(this.data);
    }

    @Nullable
    public ByteBuffer getRawData() {
        return this.data;
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return "reasonCode=" + this.getReasonCode() + ", method=" + this.method + (this.data == null ? "" : ", data=" + this.data.remaining() + "byte") + StringUtil.prepend(", ", super.toAttributeString());
    }

    @NotNull
    public String toString() {
        return "MqttAuth{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttAuth)) {
            return false;
        }
        MqttAuth that = (MqttAuth)o;
        return this.partialEquals(that) && this.method.equals(that.method) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = this.partialHashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + Objects.hashCode(this.data);
        return result;
    }
}

