/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J#\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\b\u0010\u001f\u001a\u0004\u0018\u0001H\u0019H\u0016\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/indexing/shared/platform/impl/HashSuppliedIndexedFile;", "Lcom/intellij/util/indexing/FileContent;", "indexedFile", "Lcom/intellij/util/indexing/IndexedFile;", "hashId", "", "<init>", "(Lcom/intellij/util/indexing/IndexedFile;J)V", "getHashId", "()J", "getContent", "", "getContentAsText", "", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileName", "", "getProject", "Lcom/intellij/openapi/project/Project;", "getUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "intellij.indexing.shared"})
public final class HashSuppliedIndexedFile
implements FileContent {
    @NotNull
    private final IndexedFile indexedFile;
    private final long hashId;

    public HashSuppliedIndexedFile(@NotNull IndexedFile indexedFile, long hashId) {
        Intrinsics.checkNotNullParameter((Object)indexedFile, (String)"indexedFile");
        this.indexedFile = indexedFile;
        this.hashId = hashId;
    }

    public final long getHashId() {
        return this.hashId;
    }

    @NotNull
    public byte[] getContent() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public CharSequence getContentAsText() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiFile getPsiFile() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.indexedFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return fileType;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.indexedFile.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return virtualFile;
    }

    @NotNull
    public String getFileName() {
        String string = this.indexedFile.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project = this.indexedFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.indexedFile.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.indexedFile.putUserData(key, value);
    }
}

