/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.completion.ml.experiments.ExperimentInfo;
import com.intellij.completion.ml.experiments.ExperimentStatus;
import com.intellij.completion.ml.ranker.ExperimentModelProvider;
import com.intellij.completion.ml.ranker.local.MLCompletionLocalModelsLoader;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.sorting.LanguageRankingModel;
import com.intellij.completion.ml.sorting.RankingModelWrapper;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.completion.DecoratingItemsPolicy;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/completion/ml/sorting/RankingSupport;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "enabledInTests", "", "localDebugModelLoader", "Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader;", "getRankingModel", "Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "language", "Lcom/intellij/lang/Language;", "availableRankers", "", "Lcom/intellij/internal/ml/completion/RankingModelProvider;", "findProviderSafe", "loadLocalDebugModel", "Lcom/intellij/completion/ml/sorting/LanguageRankingModel;", "tryGetModel", "provider", "shouldSortByML", "tryLoadLocalDebugModel", "synchronous", "enableInTests", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nRankingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankingSupport.kt\ncom/intellij/completion/ml/sorting/RankingSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n1#2:95\n774#3:96\n865#3:97\n1761#3,3:98\n866#3:101\n14#4:102\n*S KotlinDebug\n*F\n+ 1 RankingSupport.kt\ncom/intellij/completion/ml/sorting/RankingSupport\n*L\n35#1:96\n35#1:97\n36#1:98,3\n35#1:101\n20#1:102\n*E\n"})
public final class RankingSupport {
    @NotNull
    public static final RankingSupport INSTANCE = new RankingSupport();
    @NotNull
    private static final Logger LOG;
    private static boolean enabledInTests;
    @NotNull
    private static final MLCompletionLocalModelsLoader localDebugModelLoader;

    private RankingSupport() {
    }

    @Nullable
    public final RankingModelWrapper getRankingModel(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LanguageRankingModel languageRankingModel = RankingSupport.tryLoadLocalDebugModel$default(this, language, false, 2, null);
        if (languageRankingModel != null) {
            LanguageRankingModel it = languageRankingModel;
            boolean bl = false;
            return it;
        }
        RankingModelProvider provider = this.findProviderSafe(language);
        return provider != null && this.shouldSortByML(language, provider) ? this.tryGetModel(provider) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RankingModelProvider> availableRankers() {
        void $this$filterTo$iv$iv;
        Collection collection = Language.getRegisteredLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
        Collection registeredLanguages = collection;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        Iterable $this$filter$iv = ExperimentModelProvider.Companion.availableProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                RankingModelProvider provider = (RankingModelProvider)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = registeredLanguages;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Language it = (Language)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!ExperimentModelProvider.Companion.match(provider, it, experimentStatus.forLanguage(it).getVersion())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final RankingModelProvider findProviderSafe(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        ExperimentInfo experimentInfo = ExperimentStatus.Companion.getInstance().forLanguage(language);
        try {
            return ExperimentModelProvider.Companion.findProvider(language, experimentInfo.getVersion());
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @ApiStatus.Internal
    @Nullable
    public final LanguageRankingModel loadLocalDebugModel(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.tryLoadLocalDebugModel(language, true);
    }

    private final RankingModelWrapper tryGetModel(RankingModelProvider provider) {
        try {
            DecisionFunction decisionFunction = provider.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)decisionFunction, (String)"getModel(...)");
            DecoratingItemsPolicy decoratingItemsPolicy = provider.getDecoratingPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)decoratingItemsPolicy, (String)"getDecoratingPolicy(...)");
            return new LanguageRankingModel(decisionFunction, decoratingItemsPolicy);
        }
        catch (Exception e) {
            LOG.error("Could not create ranking model with id '" + provider.getId() + "' and name '" + provider.getDisplayNameInSettings() + "'", (Throwable)e);
            return null;
        }
    }

    private final boolean shouldSortByML(Language language, RankingModelProvider provider) {
        boolean shouldSort;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return enabledInTests;
        }
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"getInstance(...)");
        CompletionMLRankingSettings settings = completionMLRankingSettings;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        ExperimentInfo experimentInfo = experimentStatus.forLanguage(language);
        boolean bl = shouldSort = settings.isRankingEnabled() && settings.isLanguageEnabled(provider.getId());
        if (application.isEAP() && experimentInfo.getInExperiment() && !experimentStatus.isDisabled()) {
            settings.updateShowDiffInExperiment(experimentInfo.getShouldShowArrows());
        }
        return shouldSort;
    }

    private final LanguageRankingModel tryLoadLocalDebugModel(Language language, boolean synchronous) {
        String string = language.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        DecisionFunction decisionFunction = localDebugModelLoader.getModel(string, synchronous);
        if (decisionFunction != null) {
            DecisionFunction it = decisionFunction;
            boolean bl = false;
            return new LanguageRankingModel(it, DecoratingItemsPolicy.Companion.getDISABLED());
        }
        return null;
    }

    static /* synthetic */ LanguageRankingModel tryLoadLocalDebugModel$default(RankingSupport rankingSupport, Language language, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return rankingSupport.tryLoadLocalDebugModel(language, bl);
    }

    @TestOnly
    public final void enableInTests(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        enabledInTests = true;
        Disposer.register((Disposable)parentDisposable, RankingSupport::enableInTests$lambda$4);
    }

    private static final void enableInTests$lambda$4() {
        enabledInTests = false;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RankingSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        localDebugModelLoader = new MLCompletionLocalModelsLoader("completion.ml.path.to.zip.model");
    }
}

