/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.extensions.ExtensionsService;
import com.intellij.database.extensions.ScriptsCleanup;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractorScripts {
    public static final String EXTRACTORS_SCRIPT_DIR = "data/extractors";
    public static final String AGGREGATORS_SCRIPT_DIR = "data/aggregators";
    private static final Pattern FILE_PATTERN = Pattern.compile("(.+?)(?:\\.(\\w+))?\\.\\w+");

    private ExtractorScripts() {
    }

    @Nullable
    public static File getExtractorScriptsDirectory() {
        Path result = ExtractorScripts.getScriptDirectoryImpl(false);
        return result == null ? null : result.toFile();
    }

    @Nullable
    public static File getAggregatorScriptsDirectory() {
        Path result = ExtractorScripts.getScriptDirectoryImpl(true);
        return result == null ? null : result.toFile();
    }

    @NotNull
    public static List<Path> getExtractorScriptFiles() {
        List list = (List)ExtractorScripts.getExtractorScriptFilesWithCleanupFuture().getFirst();
        if (list == null) {
            ExtractorScripts.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static Pair<List<Path>, Future<?>> getExtractorScriptFilesWithCleanupFuture() {
        Path dir = ExtractorScripts.getScriptDirectoryImpl(false);
        if (dir == null) {
            return new Pair(Collections.emptyList(), null);
        }
        Future<?> cleanupFuture = ScriptsCleanup.startScriptsCleanup(dir, EXTRACTORS_SCRIPT_DIR);
        return new Pair(ExtractorScripts.getScriptFiles(dir), cleanupFuture);
    }

    @NotNull
    public static List<Path> getAggregatorScriptFiles() {
        Path dir = ExtractorScripts.getScriptDirectoryImpl(true);
        if (dir == null) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                ExtractorScripts.$$$reportNull$$$0(1);
            }
            return list;
        }
        ScriptsCleanup.startScriptsCleanup(dir, AGGREGATORS_SCRIPT_DIR);
        return ExtractorScripts.getScriptFiles(dir);
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> getScriptFiles(Path directory) {
        List<Path> list;
        Stream<Path> stream;
        block12: {
            if (directory == null) {
                List<Path> list2 = Collections.emptyList();
                if (list2 == null) {
                    ExtractorScripts.$$$reportNull$$$0(2);
                }
                return list2;
            }
            stream = Files.list(directory);
            list = stream.filter(ExtensionsService.getInstance().extensionsRootTypeRegularFileFilter()).filter(o -> FILE_PATTERN.matcher(o.getFileName().toString()).matches()).collect(Collectors.toList());
            if (stream == null) break block12;
            stream.close();
        }
        List<Path> list3 = list;
        if (list3 == null) {
            ExtractorScripts.$$$reportNull$$$0(3);
        }
        return list3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignore) {
                    List<Path> list4 = Collections.emptyList();
                    if (list4 == null) {
                        ExtractorScripts.$$$reportNull$$$0(4);
                    }
                    return list4;
                }
            }
        }
    }

    @Nullable
    public static Path findExtractorScript(String name) {
        return ExtractorScripts.findScript(name, false);
    }

    @Nullable
    public static Path findAggregatorScript(String name) {
        return ExtractorScripts.findScript(name, true);
    }

    private static Path findScript(String name, boolean isAggregatorScript) {
        try {
            PluginId id = ExtractorScripts.getPluginId();
            return id == null ? null : ExtensionsService.getInstance().extensionsRootTypeFindResource(id, isAggregatorScript ? "data/aggregators/" + name : "data/extractors/" + name);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String getOutputFileExtension(@NotNull String scriptFileName) {
        if (scriptFileName == null) {
            ExtractorScripts.$$$reportNull$$$0(5);
        }
        return ExtractorScripts.getNamePart(scriptFileName, 2, "txt");
    }

    @NotNull
    private static String getNamePart(String name, int namePart, String def) {
        String string;
        Matcher matcher = FILE_PATTERN.matcher(name);
        try {
            string = matcher.matches() ? StringUtil.notNullize((String)matcher.group(namePart), (String)def) : def;
        }
        catch (Exception ignore) {
            String string2 = def;
            if (string2 == null) {
                ExtractorScripts.$$$reportNull$$$0(7);
            }
            return string2;
        }
        if (string == null) {
            ExtractorScripts.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static Path getScriptDirectoryImpl(boolean isAggregatorsDir) {
        try {
            PluginId id = ExtractorScripts.getPluginId();
            return id == null ? null : ExtensionsService.getInstance().extensionsRootTypeFindResourceDirectory(id, isAggregatorsDir ? AGGREGATORS_SCRIPT_DIR : EXTRACTORS_SCRIPT_DIR, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static PluginId getPluginId() {
        return PluginId.findId((String)"com.intellij.database");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/ExtractorScripts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorScriptFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAggregatorScriptFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/ExtractorScripts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFileExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

