/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.ArrayDeque;
import java.util.ArrayList;

public class GlobPatternUtil {
    public static boolean matches(String pattern, String input) {
        if (input == null && pattern == null) {
            return true;
        }
        if (input == null || pattern == null) {
            return false;
        }
        String[] wcs = GlobPatternUtil.splitOnTokens(pattern);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        ArrayDeque<int[]> backtrack = new ArrayDeque<int[]>(wcs.length);
        do {
            if (!backtrack.isEmpty()) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > input.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = input.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = GlobPatternUtil.checkIndexOf(input, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = GlobPatternUtil.checkIndexOf(input, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!input.regionMatches(false, textIdx, wcs[wcsIdx], 0, wcs[wcsIdx].length())) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != input.length()) continue;
            return true;
        } while (!backtrack.isEmpty());
        return false;
    }

    private static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char prevChar = '\u0000';
        for (char ch : array) {
            if (ch == '?' || ch == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == '?') {
                    list.add("?");
                } else if (prevChar != '*') {
                    list.add("*");
                }
            } else {
                buffer.append(ch);
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[0]);
    }

    private static int checkIndexOf(String str, int strStartIndex, String search) {
        int endIndex = str.length() - search.length();
        if (endIndex >= strStartIndex) {
            for (int i = strStartIndex; i <= endIndex; ++i) {
                if (!str.regionMatches(false, i, search, 0, search.length())) continue;
                return i;
            }
        }
        return -1;
    }
}

