/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerSolrResponseSerializer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.api.collections.DistributedCollectionConfigSetCommandRunner;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetAPIBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    protected final Optional<DistributedCollectionConfigSetCommandRunner> distributedCollectionConfigSetCommandRunner;
    protected final ConfigSetService configSetService;

    public ConfigSetAPIBase(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.distributedCollectionConfigSetCommandRunner = coreContainer.getDistributedCollectionCommandRunner();
        this.configSetService = coreContainer.getConfigSetService();
    }

    protected void runConfigSetCommand(SolrQueryResponse rsp, ConfigSetParams.ConfigSetAction action, Map<String, Object> messageToSend) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Invoked ConfigSet Action :{} with params {} ", (Object)action.toLower(), messageToSend);
        }
        if (this.distributedCollectionConfigSetCommandRunner.isPresent()) {
            this.distributedCollectionConfigSetCommandRunner.get().runConfigSetCommand(rsp, action, messageToSend, ConfigSetsHandler.CONFIG_SET_TIMEOUT);
        } else {
            this.sendToOverseer(rsp, action, messageToSend);
        }
    }

    protected void ensureConfigSetUploadEnabled() {
        if (!"true".equals(System.getProperty("configset.upload.enabled", "true"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Configset upload feature is disabled. To enable this, start Solr with '-Dconfigset.upload.enabled=true'.");
        }
    }

    protected InputStream ensureNonEmptyInputStream(SolrQueryRequest req) throws IOException {
        Iterator<ContentStream> contentStreamsIterator = req.getContentStreams().iterator();
        if (!contentStreamsIterator.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No stream found for the config data to be uploaded");
        }
        return contentStreamsIterator.next().getStream();
    }

    public static boolean isTrusted(Principal userPrincipal, AuthenticationPlugin authPlugin) {
        if (authPlugin != null && userPrincipal != null) {
            log.debug("Trusted configset request");
            return true;
        }
        log.debug("Untrusted configset request");
        return false;
    }

    protected void createBaseNode(ConfigSetService configSetService, boolean overwritesExisting, boolean requestIsTrusted, String configName) throws IOException {
        if (overwritesExisting) {
            if (!requestIsTrusted) {
                this.ensureOverwritingUntrustedConfigSet(configName);
            }
        } else {
            configSetService.setConfigSetTrust(configName, requestIsTrusted);
        }
    }

    private void ensureOverwritingUntrustedConfigSet(String configName) throws IOException {
        boolean isCurrentlyTrusted = this.configSetService.isConfigSetTrusted(configName);
        if (isCurrentlyTrusted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Trying to make an untrusted ConfigSet update on a trusted configSet");
        }
    }

    private void sendToOverseer(SolrQueryResponse rsp, ConfigSetParams.ConfigSetAction action, Map<String, Object> result) throws KeeperException, InterruptedException {
        result.put("operation", "configsets:" + action.toLower());
        ZkNodeProps props = new ZkNodeProps(result);
        this.handleResponse(action.toLower(), props, rsp, ConfigSetsHandler.CONFIG_SET_TIMEOUT);
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerConfigSetQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            OverseerSolrResponse response = OverseerSolrResponseSerializer.deserialize(event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset unknown case");
        }
    }
}

