/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateHandler;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FileEntry
extends MultiDataObject.Entry {
    static final long serialVersionUID = 5972727204237511983L;

    public FileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiDataObject multiDataObject2 = multiDataObject;
        multiDataObject2.getClass();
        super(multiDataObject2, fileObject);
    }

    public FileObject copy(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = this.getFile();
        String string2 = fileObject2.getName() + string;
        return fileObject2.copy(fileObject, string2, fileObject2.getExt());
    }

    public FileObject copyRename(FileObject fileObject, String string, String string2) throws IOException {
        FileObject fileObject2 = this.getFile();
        return fileObject2.copy(fileObject, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileObject rename(String string) throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().rename(fileLock, string, this.getFile().getExt());
            Object var5_4 = null;
            if (bl) return this.getFile();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
        return this.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2;
        block2: {
            boolean bl = this.isLocked();
            FileObject fileObject3 = this.getFile();
            FileLock fileLock = this.takeLock();
            try {
                FileObject fileObject4;
                String string2 = fileObject3.getName() + string;
                fileObject2 = fileObject4 = fileObject3.move(fileLock, fileObject, string2, fileObject3.getExt());
                Object var10_9 = null;
                if (bl) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var10_10 = null;
                    if (bl) break block3;
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            fileLock.releaseLock();
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().delete(fileLock);
            Object var4_3 = null;
            if (bl) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bl) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)this.getFile().getExt());
        }
        FileObject fileObject2 = null;
        for (CreateFromTemplateHandler createFromTemplateHandler : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
            if (!createFromTemplateHandler.accept(this.getFile())) continue;
            fileObject2 = createFromTemplateHandler.createFromTemplate(this.getFile(), fileObject, string, DataObject.CreateAction.enhanceParameters(DataObject.CreateAction.findParameters(string), string, this.getFile().getExt()));
            assert (fileObject2 != null);
            break;
        }
        if (fileObject2 == null) {
            fileObject2 = this.getFile().copy(fileObject, string, this.getFile().getExt());
        }
        DataObject.setTemplate(fileObject2, false);
        return fileObject2;
    }

    public static final class Folder
    extends MultiDataObject.Entry {
        public Folder(MultiDataObject multiDataObject, FileObject fileObject) {
            MultiDataObject multiDataObject2 = multiDataObject;
            multiDataObject2.getClass();
            super(multiDataObject2, fileObject);
        }

        public FileObject copy(FileObject fileObject, String string) throws IOException {
            String string2 = string + (this.getFile().getExt().length() > 0 ? "." + this.getFile().getExt() : "");
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)(this.getFile().getName() + string2));
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            return fileObject2;
        }

        public FileObject move(FileObject fileObject, String string) throws IOException {
            return this.copy(fileObject, string);
        }

        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)this.getFile().getExt());
            }
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FileObject rename(String string) throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().rename(fileLock, string, null);
                Object var5_4 = null;
                if (bl) return this.getFile();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (bl) throw throwable;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            return this.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void delete() throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
                Object var4_3 = null;
                if (bl) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (bl) throw throwable;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
        }
    }

    public static final class Numb
    extends MultiDataObject.Entry {
        static final long serialVersionUID = -6572157492885890612L;

        public Numb(MultiDataObject multiDataObject, FileObject fileObject) {
            MultiDataObject multiDataObject2 = multiDataObject;
            multiDataObject2.getClass();
            super(multiDataObject2, fileObject);
        }

        public boolean isImportant() {
            return false;
        }

        public FileObject copy(FileObject fileObject, String string) {
            return null;
        }

        public FileObject rename(String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        public FileObject move(FileObject fileObject, String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        public void delete() throws IOException {
            this.stdBehaving();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void stdBehaving() throws IOException {
            if (this.getFile() == null) {
                return;
            }
            if (this.isLocked()) {
                throw new IOException(NbBundle.getBundle(FileEntry.class).getString("EXC_SharedAccess"));
            }
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
                Object var3_2 = null;
                if (fileLock == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (fileLock == null) throw throwable;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
        }

        public FileObject createFromTemplate(FileObject fileObject, String string) {
            return null;
        }
    }

    public static abstract class Format
    extends FileEntry {
        static final long serialVersionUID = 8896750589709521197L;

        public Format(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            Object object2;
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            FileObject fileObject2 = null;
            for (Object object2 : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
                if (!((CreateFromTemplateHandler)object2).accept(this.getFile())) continue;
                fileObject2 = ((CreateFromTemplateHandler)object2).createFromTemplate(this.getFile(), fileObject, string, DataObject.CreateAction.enhanceParameters(DataObject.CreateAction.findParameters(string), string, this.getFile().getExt()));
                assert (fileObject2 != null);
                break;
            }
            if (fileObject2 != null) {
                DataObject.setTemplate(fileObject2, false);
                return fileObject2;
            }
            fileObject2 = fileObject.createData(string, string2);
            java.text.Format format = this.createFormat(fileObject, string, string2);
            object2 = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String string3;
                        while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                            bufferedWriter.write(format.format(string3));
                            bufferedWriter.newLine();
                        }
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        bufferedWriter.close();
                        throw throwable;
                    }
                    bufferedWriter.close();
                    Object var13_13 = null;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    fileLock.releaseLock();
                    throw throwable;
                }
                fileLock.releaseLock();
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                ((BufferedReader)object2).close();
                throw throwable;
            }
            ((BufferedReader)object2).close();
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        protected abstract java.text.Format createFormat(FileObject var1, String var2, String var3);
    }
}

