/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.MaximumSizeExceededException;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class PresentationTextData
extends AbstractAFPObject {
    private static final int MAX_SIZE = 8192;
    private ByteArrayOutputStream _baos = new ByteArrayOutputStream(1024);
    private int _currentXCoordinate = -1;
    private int _currentYCoordinate = -1;
    private String _currentFont = "";
    private int _currentOrientation = 0;
    private Color _currentColor = new Color(0, 0, 0);
    private int _currentVariableSpaceCharacterIncrement = 0;
    private int _currentInterCharacterAdjustment = 0;

    public PresentationTextData() {
        this(false);
    }

    public PresentationTextData(boolean controlInd) {
        this._baos.write(new byte[]{90, 0, 0, -45, -18, -101, 0, 0, 0}, 0, 9);
        if (controlInd) {
            this._baos.write(new byte[]{43, -45}, 0, 2);
        }
    }

    private void setCodedFont(byte font, ByteArrayOutputStream afpdata) {
        if (String.valueOf(font).equals(this._currentFont)) {
            return;
        }
        this._currentFont = String.valueOf(font);
        afpdata.write(new byte[]{3, -15, font}, 0, 3);
    }

    private void absoluteMoveInline(int coordinate, ByteArrayOutputStream afpdata) {
        byte[] b = BinaryUtils.convert(coordinate, 2);
        afpdata.write(new byte[]{4, -57, b[0], b[1]}, 0, 4);
        this._currentXCoordinate = coordinate;
    }

    private void absoluteMoveBaseline(int coordinate, ByteArrayOutputStream afpdata) {
        byte[] b = BinaryUtils.convert(coordinate, 2);
        afpdata.write(new byte[]{4, -45, b[0], b[1]}, 0, 4);
        this._currentYCoordinate = coordinate;
    }

    private void addTransparentData(byte[] data, ByteArrayOutputStream afpdata) {
        int l = data.length + 2;
        if (l > 255) {
            throw new IllegalArgumentException("Transparent data is longer than 253 bytes: " + data);
        }
        afpdata.write(new byte[]{BinaryUtils.convert(l)[0], -37}, 0, 2);
        afpdata.write(data, 0, data.length);
    }

    private void drawBaxisRule(int length, int width, ByteArrayOutputStream afpdata) {
        afpdata.write(new byte[]{7, -25}, 0, 2);
        byte[] data1 = BinaryUtils.shortToByteArray((short)length);
        afpdata.write(data1, 0, data1.length);
        byte[] data2 = BinaryUtils.shortToByteArray((short)width);
        afpdata.write(data2, 0, data2.length);
        afpdata.write(0);
    }

    private void drawIaxisRule(int length, int width, ByteArrayOutputStream afpdata) {
        afpdata.write(new byte[]{7, -27}, 0, 2);
        byte[] data1 = BinaryUtils.shortToByteArray((short)length);
        afpdata.write(data1, 0, data1.length);
        byte[] data2 = BinaryUtils.shortToByteArray((short)width);
        afpdata.write(data2, 0, data2.length);
        afpdata.write(0);
    }

    public void createTextData(int fontNumber, int x, int y, int orientation, Color col, int vsci, int ica, byte[] data) throws MaximumSizeExceededException {
        ByteArrayOutputStream afpdata = new ByteArrayOutputStream();
        if (this._currentOrientation != orientation) {
            this.setTextOrientation(orientation, afpdata);
            this._currentOrientation = orientation;
            this._currentXCoordinate = -1;
            this._currentYCoordinate = -1;
        }
        if (y != this._currentYCoordinate) {
            this.absoluteMoveBaseline(y, afpdata);
            this._currentXCoordinate = -1;
        }
        if (x != this._currentXCoordinate) {
            this.absoluteMoveInline(x, afpdata);
        }
        if (vsci != this._currentVariableSpaceCharacterIncrement) {
            this.setVariableSpaceCharacterIncrement(vsci, afpdata);
            this._currentVariableSpaceCharacterIncrement = vsci;
        }
        if (ica != this._currentInterCharacterAdjustment) {
            this.setInterCharacterAdjustment(ica, afpdata);
            this._currentInterCharacterAdjustment = ica;
        }
        if (!col.equals(this._currentColor)) {
            this.setExtendedTextColor(col, afpdata);
            this._currentColor = col;
        }
        this.setCodedFont(BinaryUtils.convert(fontNumber)[0], afpdata);
        this.addTransparentData(data, afpdata);
        this._currentXCoordinate = -1;
        int s = afpdata.size();
        if (this._baos.size() + s > 8192) {
            this._currentXCoordinate = -1;
            this._currentYCoordinate = -1;
            throw new MaximumSizeExceededException();
        }
        byte[] outputdata = afpdata.toByteArray();
        this._baos.write(outputdata, 0, outputdata.length);
    }

    public void createLineData(int x1, int y1, int x2, int y2, int thickness, int orientation, Color col) throws MaximumSizeExceededException {
        ByteArrayOutputStream afpdata = new ByteArrayOutputStream();
        if (this._currentOrientation != orientation) {
            this.setTextOrientation(orientation, afpdata);
            this._currentOrientation = orientation;
        }
        if (y1 != this._currentYCoordinate) {
            this.absoluteMoveBaseline(y1, afpdata);
        }
        if (x1 != this._currentXCoordinate) {
            this.absoluteMoveInline(x1, afpdata);
        }
        if (!col.equals(this._currentColor)) {
            this.setExtendedTextColor(col, afpdata);
            this._currentColor = col;
        }
        if (y1 == y2) {
            this.drawIaxisRule(x2 - x1, thickness, afpdata);
        } else if (x1 == x2) {
            this.drawBaxisRule(y2 - y1, thickness, afpdata);
        } else {
            return;
        }
        int s = afpdata.size();
        if (this._baos.size() + s > 8192) {
            this._currentXCoordinate = -1;
            this._currentYCoordinate = -1;
            throw new MaximumSizeExceededException();
        }
        byte[] outputdata = afpdata.toByteArray();
        this._baos.write(outputdata, 0, outputdata.length);
    }

    private void setTextOrientation(int orientation, ByteArrayOutputStream afpdata) {
        afpdata.write(new byte[]{6, -9}, 0, 2);
        switch (orientation) {
            case 90: {
                afpdata.write(45);
                afpdata.write(0);
                afpdata.write(90);
                afpdata.write(0);
                break;
            }
            case 180: {
                afpdata.write(90);
                afpdata.write(0);
                afpdata.write(135);
                afpdata.write(0);
                break;
            }
            case 270: {
                afpdata.write(135);
                afpdata.write(0);
                afpdata.write(0);
                afpdata.write(0);
                break;
            }
            default: {
                afpdata.write(0);
                afpdata.write(0);
                afpdata.write(45);
                afpdata.write(0);
            }
        }
    }

    private void setExtendedTextColor(Color col, ByteArrayOutputStream afpdata) {
        afpdata.write(new byte[]{15, -127, 0, 1, 0, 0, 0, 0, 8, 8, 8, 0, (byte)col.getRed(), (byte)col.getGreen(), (byte)col.getBlue()}, 0, 15);
    }

    private void setVariableSpaceCharacterIncrement(int incr, ByteArrayOutputStream afpdata) {
        byte[] b = BinaryUtils.convert(incr, 2);
        afpdata.write(new byte[]{4, -59, b[0], b[1]}, 0, 4);
    }

    private void setInterCharacterAdjustment(int incr, ByteArrayOutputStream afpdata) {
        byte[] b = BinaryUtils.convert(Math.abs(incr), 2);
        afpdata.write(new byte[]{5, -61, b[0], b[1], (byte)(incr < 0 ? 1 : 0)}, 0, 5);
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = this._baos.toByteArray();
        byte[] size = BinaryUtils.convert(data.length - 1, 2);
        data[1] = size[0];
        data[2] = size[1];
        os.write(data);
    }

    public void endControlSequence() throws MaximumSizeExceededException {
        byte[] data = new byte[]{2, -8};
        if (data.length + this._baos.size() > 8192) {
            throw new MaximumSizeExceededException();
        }
        this._baos.write(data, 0, data.length);
    }
}

