/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate.ocsp;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1PrimitivePrintableString;
import de.rub.nds.asn1.model.Asn1PrimitiveUtf8String;
import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.asn1.model.Asn1Set;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.certificate.CrlReason;
import de.rub.nds.tlsattacker.core.certificate.ObjectIdentifierTranslator;
import de.rub.nds.tlsattacker.core.certificate.ocsp.CertificateStatus;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponseStatus;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponseTypes;
import de.rub.nds.tlsattacker.core.certificate.ocsp.RevocationStatus;
import java.io.IOException;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.util.encoders.Hex;

public class OCSPResponse {
    private List<CertificateStatus> certificateStatusList = new LinkedList<CertificateStatus>();
    private byte[] encodedResponse;
    private byte[] responderKey;
    private Integer responseStatus;
    private Integer responseDataVersion;
    private BigInteger nonce;
    private String producedAt;
    private String responseTypeIdentifier;
    private String signatureAlgorithmIdentifier;
    private byte[] signature;
    private List<Asn1Encodable> responderName;
    private org.bouncycastle.crypto.tls.Certificate certificate;

    public List<CertificateStatus> getCertificateStatusList() {
        return this.certificateStatusList;
    }

    public void setCertificateStatusList(List<CertificateStatus> certificateStatusList) {
        this.certificateStatusList = certificateStatusList;
    }

    public byte[] getEncodedResponse() {
        return this.encodedResponse;
    }

    public void setEncodedResponse(byte[] encodedResponse) {
        this.encodedResponse = encodedResponse;
    }

    public byte[] getResponderKey() {
        return this.responderKey;
    }

    public void setResponderKey(byte[] responderKey) {
        this.responderKey = responderKey;
    }

    public Integer getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(Integer responseStatus) {
        this.responseStatus = responseStatus;
    }

    public Integer getResponseDataVersion() {
        return this.responseDataVersion;
    }

    public void setResponseDataVersion(Integer responseDataVersion) {
        this.responseDataVersion = responseDataVersion;
    }

    public String getProducedAt() {
        return this.producedAt;
    }

    public void setProducedAt(String producedAt) {
        this.producedAt = producedAt;
    }

    public String getResponseTypeIdentifier() {
        return this.responseTypeIdentifier;
    }

    public void setResponseTypeIdentifier(String responseTypeIdentifier) {
        this.responseTypeIdentifier = responseTypeIdentifier;
    }

    public String getSignatureAlgorithmIdentifier() {
        return this.signatureAlgorithmIdentifier;
    }

    public void setSignatureAlgorithmIdentifier(String signatureAlgorithmIdentifier) {
        this.signatureAlgorithmIdentifier = signatureAlgorithmIdentifier;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public List<Asn1Encodable> getResponderName() {
        return this.responderName;
    }

    public void setResponderName(List<Asn1Encodable> responderName) {
        this.responderName = responderName;
    }

    public org.bouncycastle.crypto.tls.Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(org.bouncycastle.crypto.tls.Certificate certificate) {
        this.certificate = certificate;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    private String formatDate(String unformattedDateString) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss'Z'", Locale.ENGLISH);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        LocalDateTime date = LocalDateTime.parse(unformattedDateString, inputFormatter);
        return outputFormatter.format(date);
    }

    private String parseResponderName() {
        StringBuilder sb = new StringBuilder();
        for (Asn1Encodable enc : this.responderName) {
            if (!(enc instanceof Asn1Set)) continue;
            Asn1Sequence sequence = (Asn1Sequence)((Asn1Set)enc).getChildren().get(0);
            List dnKeyValue = sequence.getChildren();
            String oid = ((Asn1ObjectIdentifier)dnKeyValue.get(0)).getValue();
            String value = "";
            if (dnKeyValue.get(1) instanceof Asn1PrimitivePrintableString) {
                value = ((Asn1PrimitivePrintableString)dnKeyValue.get(1)).getValue();
            } else if (dnKeyValue.get(1) instanceof Asn1PrimitiveUtf8String) {
                value = ((Asn1PrimitiveUtf8String)dnKeyValue.get(1)).getValue();
            }
            sb.append("\n   ").append(ObjectIdentifierTranslator.translate(oid)).append(": ").append(value);
        }
        return sb.toString();
    }

    private byte[] getResponseCertificateBytes() throws IOException {
        Certificate certificate = this.certificate.getCertificateAt(0);
        return certificate.getEncoded();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeSignatureAndCertificate) {
        StringBuilder sb = new StringBuilder();
        sb.append("OCSP Response:");
        if (this.getResponseStatus() != null && this.getResponseStatus() > 0) {
            sb.append(OCSPResponseStatus.translate(this.getResponseStatus()));
            return sb.toString();
        }
        sb.append("\n Version: ");
        if (this.getResponseDataVersion() == null || this.getResponseDataVersion() == 0) {
            sb.append("1 (0x0)");
        } else {
            sb.append(Integer.toHexString(this.getResponseDataVersion()));
        }
        sb.append("\n Produced at: ").append(this.formatDate(this.getProducedAt()));
        sb.append("\n Response Type: ");
        if (this.getResponseTypeIdentifier().equals(OCSPResponseTypes.BASIC.getOID())) {
            sb.append("OCSP Basic Response");
        } else {
            sb.append(this.getResponseTypeIdentifier());
        }
        if (this.getResponderName() != null) {
            sb.append("\n Responder DN: ").append(this.parseResponderName());
        } else if (this.getResponderKey() != null) {
            sb.append("\n Responder ID: ").append(Hex.toHexString((byte[])this.getResponderKey()));
        }
        if (this.getNonce() != null) {
            sb.append("\n Nonce: ").append(this.getNonce().toString());
        }
        int certificateCounter = 0;
        for (CertificateStatus certificateStatus : this.getCertificateStatusList()) {
            sb.append("\n Certificate Status No. ").append(++certificateCounter);
            sb.append("\n   Hash Algorithm: ").append(ObjectIdentifierTranslator.translate(certificateStatus.getHashAlgorithmIdentifier()));
            sb.append("\n   Issuer Name Hash: ").append(Hex.toHexString((byte[])certificateStatus.getIssuerNameHash()));
            sb.append("\n   Issuer Key Hash: ").append(Hex.toHexString((byte[])certificateStatus.getIssuerKeyHash()));
            sb.append("\n   Serial Number: ").append("0x").append(certificateStatus.getSerialNumber().toString(16));
            sb.append("\n   Certificate Status: ");
            sb.append(RevocationStatus.translate(certificateStatus.getCertificateStatus()));
            if (certificateStatus.getCertificateStatus().equals(RevocationStatus.translate("revoked"))) {
                sb.append("\n    Revocation Time: ").append(this.formatDate(certificateStatus.getRevocationTime()));
                if (certificateStatus.getRevocationReason() != null) {
                    sb.append("\n    Revocation Reason: ");
                    sb.append(CrlReason.translate(certificateStatus.getRevocationReason()));
                }
            }
            sb.append("\n   Last Update: ").append(this.formatDate(certificateStatus.getTimeOfLastUpdate()));
            sb.append("\n   Next Update: ").append(this.formatDate(certificateStatus.getTimeOfNextUpdate()));
        }
        sb.append("\n Signature Algorithm: ").append(ObjectIdentifierTranslator.translate(this.getSignatureAlgorithmIdentifier()));
        if (includeSignatureAndCertificate) {
            if (this.signature != null) {
                sb.append("\n Signature: ");
                sb.append(ArrayConverter.bytesToHexString((byte[])this.signature));
            }
            if (this.getCertificate() != null) {
                try {
                    String certificateBytes = ArrayConverter.bytesToHexString((byte[])this.getResponseCertificateBytes());
                    sb.append("\n Certificate:").append(certificateBytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

