/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PopAndSendMessageAction
extends MessageAction
implements SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public PopAndSendMessageAction() {
    }

    public PopAndSendMessageAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.connectionAlias);
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.messages.add(tlsContext.getMessageBuffer().pop());
        String sending = this.getReadableString(this.messages);
        if (this.connectionAlias == null) {
            LOGGER.info("Sending messages: " + sending);
        } else {
            LOGGER.info("Sending messages (" + this.connectionAlias + "): " + sending);
        }
        try {
            MessageActionResult result = this.sendMessageHelper.sendMessages(this.messages, this.records, tlsContext, false);
            this.messages = new ArrayList<ProtocolMessage>(result.getMessageList());
            this.records = new ArrayList<AbstractRecord>(result.getRecordList());
            this.setExecuted(true);
        }
        catch (IOException E) {
            LOGGER.debug((Object)E);
            this.setExecuted(false);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PopAndSendAction:\n");
        sb.append("Messages:\n");
        for (ProtocolMessage message : this.messages) {
            sb.append(message.toCompactString());
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void setRecords(List<AbstractRecord> records) {
        this.records = records;
    }

    @Override
    public void reset() {
        this.messages = new LinkedList();
        this.records = new LinkedList();
        this.setExecuted(null);
    }

    @Override
    public List<ProtocolMessage> getSendMessages() {
        return this.messages;
    }

    @Override
    public List<AbstractRecord> getSendRecords() {
        return this.records;
    }
}

