/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.SQLObjectComboBoxModel;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.NotNullValidator;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SchemaEditPanel
implements ValidatableDataEntryPanel {
    private JPanel editorPanel;
    private MondrianModel.Schema schema;
    private final JComboBox databaseBox;
    private final JTextField nameField;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();

    public SchemaEditPanel(ArchitectSwingSession session, MondrianModel.Schema schema) throws SQLObjectException {
        this.schema = schema;
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.databaseBox = new JComboBox(new SQLObjectComboBoxModel((SQLObject)session.getRootObject(), SQLObject.class));
        builder.append("Database", this.databaseBox);
        OLAPSession osession = OLAPUtil.getSession(schema);
        if (osession.getDatabase() != null) {
            this.databaseBox.setSelectedItem(osession.getDatabase());
        } else {
            this.databaseBox.setSelectedItem(session.getTargetDatabase());
        }
        this.nameField = new JTextField(schema.getName());
        builder.append("Name", (Component)this.nameField);
        this.handler = new FormValidationHandler(this.status);
        this.handler.addValidateObject((JComponent)this.databaseBox, (Validator)new NotNullValidator("Schema"));
        this.editorPanel = builder.getPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyChanges() {
        try {
            this.schema.begin("Modify Schema Properties");
            this.schema.setName(this.nameField.getText());
            OLAPSession osession = OLAPUtil.getSession(this.schema);
            osession.setDatabase((SQLDatabase)this.databaseBox.getSelectedItem());
        }
        finally {
            this.schema.commit();
        }
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.editorPanel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public ValidationHandler getValidationHandler() {
        return this.handler;
    }
}

