/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.concurrent.SessionRegistry;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.ui.AuthenticationDetailsSource;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.TargetUrlResolver;
import org.springframework.security.ui.TargetUrlResolverImpl;
import org.springframework.security.ui.WebAuthenticationDetailsSource;
import org.springframework.security.ui.rememberme.NullRememberMeServices;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.security.util.RedirectUtils;
import org.springframework.security.util.SessionUtils;
import org.springframework.security.util.UrlUtils;
import org.springframework.util.Assert;

public abstract class AbstractProcessingFilter
extends SpringSecurityFilter
implements InitializingBean,
ApplicationEventPublisherAware,
MessageSourceAware {
    public static final String SPRING_SECURITY_SAVED_REQUEST_KEY = "SPRING_SECURITY_SAVED_REQUEST_KEY";
    public static final String SPRING_SECURITY_LAST_EXCEPTION_KEY = "SPRING_SECURITY_LAST_EXCEPTION";
    protected ApplicationEventPublisher eventPublisher;
    protected AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationManager authenticationManager;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private Properties exceptionMappings = new Properties();
    private RememberMeServices rememberMeServices = null;
    private TargetUrlResolver targetUrlResolver = new TargetUrlResolverImpl();
    private String authenticationFailureUrl;
    private String defaultTargetUrl;
    private String filterProcessesUrl = this.getDefaultFilterProcessesUrl();
    private boolean alwaysUseDefaultTargetUrl = false;
    private boolean continueChainBeforeSuccessfulAuthentication = false;
    private boolean useRelativeContext = false;
    private boolean invalidateSessionOnSuccessfulAuthentication = false;
    private boolean migrateInvalidatedSessionAttributes = true;
    private boolean allowSessionCreation = true;
    private boolean serverSideRedirect = false;
    private SessionRegistry sessionRegistry;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.filterProcessesUrl, (String)"filterProcessesUrl must be specified");
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl(this.filterProcessesUrl), (String)(this.filterProcessesUrl + " isn't a valid redirect URL"));
        Assert.hasLength((String)this.defaultTargetUrl, (String)"defaultTargetUrl must be specified");
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl(this.defaultTargetUrl), (String)(this.defaultTargetUrl + " isn't a valid redirect URL"));
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl(this.authenticationFailureUrl), (String)(this.authenticationFailureUrl + " isn't a valid redirect URL"));
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
        Assert.notNull((Object)this.targetUrlResolver, (String)"targetUrlResolver cannot be null");
        if (this.rememberMeServices == null) {
            this.rememberMeServices = new NullRememberMeServices();
        }
    }

    public abstract Authentication attemptAuthentication(HttpServletRequest var1) throws AuthenticationException;

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresAuthentication(request, response)) {
            Authentication authResult;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Request is to process authentication");
            }
            try {
                this.onPreAuthentication(request, response);
                authResult = this.attemptAuthentication(request);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(request, response, failed);
                return;
            }
            if (this.continueChainBeforeSuccessfulAuthentication) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            this.successfulAuthentication(request, response, authResult);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static String obtainFullSavedRequestUrl(HttpServletRequest request) {
        SavedRequest savedRequest = AbstractProcessingFilter.getSavedRequest(request);
        return savedRequest == null ? null : savedRequest.getFullRequestUrl();
    }

    private static SavedRequest getSavedRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        SavedRequest savedRequest = (SavedRequest)session.getAttribute(SPRING_SECURITY_SAVED_REQUEST_KEY);
        return savedRequest;
    }

    protected void onPreAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            return uri.endsWith(this.filterProcessesUrl);
        }
        return uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        RedirectUtils.sendRedirect(request, response, url, this.useRelativeContext);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updated SecurityContextHolder to contain the following Authentication: '" + authResult + "'"));
        }
        if (this.invalidateSessionOnSuccessfulAuthentication) {
            SessionUtils.startNewSessionIfRequired(request, this.migrateInvalidatedSessionAttributes, this.sessionRegistry);
        }
        String targetUrl = this.determineTargetUrl(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirecting to target URL from HTTP Session (or default): " + targetUrl));
        }
        this.onSuccessfulAuthentication(request, response, authResult);
        this.rememberMeServices.loginSuccess(request, response, authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, this.getClass()));
        }
        this.sendRedirect(request, response, targetUrl);
    }

    protected String determineTargetUrl(HttpServletRequest request) {
        String targetUrl;
        String string = targetUrl = this.alwaysUseDefaultTargetUrl ? null : this.targetUrlResolver.determineTargetUrl(AbstractProcessingFilter.getSavedRequest(request), request, SecurityContextHolder.getContext().getAuthentication());
        if (targetUrl == null) {
            targetUrl = this.getDefaultTargetUrl();
        }
        return targetUrl;
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Updated SecurityContextHolder to contain null Authentication");
        }
        String failureUrl = this.determineFailureUrl(request, failed);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication request failed: " + ((Throwable)((Object)failed)).toString()));
        }
        try {
            HttpSession session = request.getSession(false);
            if (session != null || this.allowSessionCreation) {
                request.getSession().setAttribute(SPRING_SECURITY_LAST_EXCEPTION_KEY, (Object)failed);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.onUnsuccessfulAuthentication(request, response, failed);
        this.rememberMeServices.loginFail(request, response);
        if (failureUrl == null) {
            response.sendError(401, "Authentication Failed:" + failed.getMessage());
        } else if (this.serverSideRedirect) {
            request.getRequestDispatcher(failureUrl).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            this.sendRedirect(request, response, failureUrl);
        }
    }

    protected String determineFailureUrl(HttpServletRequest request, AuthenticationException failed) {
        return this.exceptionMappings.getProperty(((Object)((Object)failed)).getClass().getName(), this.authenticationFailureUrl);
    }

    public String getAuthenticationFailureUrl() {
        return this.authenticationFailureUrl;
    }

    public void setAuthenticationFailureUrl(String authenticationFailureUrl) {
        this.authenticationFailureUrl = authenticationFailureUrl;
    }

    protected AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public abstract String getDefaultFilterProcessesUrl();

    public String getDefaultTargetUrl() {
        return this.defaultTargetUrl;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        Assert.isTrue((boolean)(defaultTargetUrl.startsWith("/") | defaultTargetUrl.startsWith("http")), (String)"defaultTarget must start with '/' or with 'http(s)'");
        this.defaultTargetUrl = defaultTargetUrl;
    }

    protected Properties getExceptionMappings() {
        return new Properties(this.exceptionMappings);
    }

    public void setExceptionMappings(Properties exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    boolean isAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    public void setAlwaysUseDefaultTargetUrl(boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    public void setContinueChainBeforeSuccessfulAuthentication(boolean continueChainBeforeSuccessfulAuthentication) {
        this.continueChainBeforeSuccessfulAuthentication = continueChainBeforeSuccessfulAuthentication;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setInvalidateSessionOnSuccessfulAuthentication(boolean invalidateSessionOnSuccessfulAuthentication) {
        this.invalidateSessionOnSuccessfulAuthentication = invalidateSessionOnSuccessfulAuthentication;
    }

    public void setMigrateInvalidatedSessionAttributes(boolean migrateInvalidatedSessionAttributes) {
        this.migrateInvalidatedSessionAttributes = migrateInvalidatedSessionAttributes;
    }

    public AuthenticationDetailsSource getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setUseRelativeContext(boolean useRelativeContext) {
        this.useRelativeContext = useRelativeContext;
    }

    protected boolean getAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    protected TargetUrlResolver getTargetUrlResolver() {
        return this.targetUrlResolver;
    }

    public void setTargetUrlResolver(TargetUrlResolver targetUrlResolver) {
        this.targetUrlResolver = targetUrlResolver;
    }

    public void setServerSideRedirect(boolean serverSideRedirect) {
        this.serverSideRedirect = serverSideRedirect;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }
}

