/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaPackage;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JRoot;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JSources
extends JNode {
    private static final long serialVersionUID = 8962924556824862801L;
    private static final ImageIcon ROOT_ICON = UiUtils.openSvgIcon("nodes/packageClasses");
    private final transient JadxWrapper wrapper;
    private final transient boolean flatPackages;

    public JSources(JRoot jRoot, JadxWrapper wrapper) {
        this.flatPackages = jRoot.isFlatPackages();
        this.wrapper = wrapper;
        this.update();
    }

    public final void update() {
        this.removeAllChildren();
        if (this.flatPackages) {
            for (JavaPackage pkg : this.wrapper.getPackages()) {
                this.add(new JPackage(pkg, this.wrapper));
            }
        } else {
            List<JPackage> rootPkgs = this.getHierarchyPackages(this.wrapper.getPackages());
            for (JPackage jPackage : rootPkgs) {
                jPackage.update();
                this.add(jPackage);
            }
        }
    }

    List<JPackage> getHierarchyPackages(List<JavaPackage> packages) {
        boolean repeat;
        HashMap<String, JPackage> pkgMap = new HashMap<String, JPackage>();
        for (JavaPackage javaPackage : packages) {
            this.addPackage(pkgMap, new JPackage(javaPackage, this.wrapper));
        }
        block1: do {
            repeat = false;
            for (Object pkg3 : pkgMap.values()) {
                List<JPackage> innerPackages = ((JPackage)pkg3).getInnerPackages();
                if (innerPackages.size() != 1 || !((JPackage)pkg3).getClasses().isEmpty()) continue;
                JPackage innerPkg = innerPackages.get(0);
                ((JPackage)pkg3).setInnerPackages(innerPkg.getInnerPackages());
                ((JPackage)pkg3).setClasses(innerPkg.getClasses());
                String innerName = '.' + innerPkg.getName();
                ((JPackage)pkg3).updateBothNames(((JPackage)pkg3).getFullName() + innerName, ((JPackage)pkg3).getName() + innerName, this.wrapper);
                innerPkg.setInnerPackages(Collections.emptyList());
                innerPkg.setClasses(Collections.emptyList());
                repeat = true;
                continue block1;
            }
        } while (repeat);
        pkgMap.values().removeIf(pkg -> pkg.getInnerPackages().isEmpty() && pkg.getClasses().isEmpty());
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        for (JPackage pkg4 : pkgMap.values()) {
            set.addAll(pkg4.getInnerPackages());
        }
        ArrayList<JPackage> rootPkgs = new ArrayList<JPackage>();
        for (JPackage pkg5 : pkgMap.values()) {
            if (set.contains(pkg5)) continue;
            rootPkgs.add(pkg5);
        }
        Collections.sort(rootPkgs);
        return rootPkgs;
    }

    private void addPackage(Map<String, JPackage> pkgs, JPackage pkg) {
        int dot;
        String pkgName = pkg.getFullName();
        JPackage replaced = pkgs.put(pkgName, pkg);
        if (replaced != null) {
            pkg.getInnerPackages().addAll(replaced.getInnerPackages());
            pkg.getClasses().addAll(replaced.getClasses());
        }
        if ((dot = pkgName.lastIndexOf(46)) > 0) {
            String prevPart = pkgName.substring(0, dot);
            String shortName = pkgName.substring(dot + 1);
            pkg.updateName(shortName);
            JPackage prevPkg = pkgs.get(prevPart);
            if (prevPkg == null) {
                prevPkg = new JPackage(prevPart, this.wrapper);
                this.addPackage(pkgs, prevPkg);
            }
            prevPkg.getInnerPackages().add(pkg);
        }
    }

    @Override
    public Icon getIcon() {
        return ROOT_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public String makeString() {
        return NLS.str("tree.sources_title");
    }
}

