/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.util.exception.ExceptionUtil;

public abstract class AbstractSourceSaverProvider
implements SourceSaver {
    protected List<String> externalSelectors;
    protected Pattern externalPathPattern;

    public AbstractSourceSaverProvider() {
        Properties properties;
        block15: {
            properties = new Properties();
            Class<?> clazz = this.getClass();
            try (InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".properties");){
                if (is != null) {
                    properties.load(is);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block15;
                throw new AssertionError();
            }
        }
        this.init(properties);
    }

    protected void init(Properties properties) {
        String pathRegExp;
        String selectors = properties.getProperty("selectors");
        if (selectors != null) {
            this.externalSelectors = Arrays.asList(selectors.split(","));
        }
        if ((pathRegExp = properties.getProperty("pathRegExp")) != null) {
            this.externalPathPattern = Pattern.compile(pathRegExp);
        }
    }

    protected String[] appendSelectors(String selector) {
        if (this.externalSelectors == null) {
            return new String[]{selector};
        }
        int size = this.externalSelectors.size();
        String[] array = new String[size + 1];
        this.externalSelectors.toArray(array);
        array[size] = selector;
        return array;
    }

    protected String[] appendSelectors(String ... selectors) {
        if (this.externalSelectors == null) {
            return selectors;
        }
        int size = this.externalSelectors.size();
        String[] array = new String[size + selectors.length];
        this.externalSelectors.toArray(array);
        System.arraycopy(selectors, 0, array, size, selectors.length);
        return array;
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern;
    }
}

