/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.NameValue;
import gov.nist.javax.sdp.fields.SDPField;
import javax.sdp.Attribute;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class AttributeField
extends SDPField
implements Attribute {
    protected NameValue attribute;

    public NameValue getAttribute() {
        return this.attribute;
    }

    public AttributeField() {
        super("a=");
    }

    public void setAttribute(NameValue a) {
        this.attribute = a;
        this.attribute.setSeparator(":");
    }

    @Override
    public String encode() {
        String encoded_string = "a=";
        if (this.attribute != null) {
            encoded_string = encoded_string + this.attribute.encode();
        }
        return encoded_string + "\r\n";
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public String getName() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        String name = nameValue.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    @Override
    public void setName(String name) throws SdpException {
        if (name == null) {
            throw new SdpException("The name is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setName(name);
        this.setAttribute(nameValue);
    }

    @Override
    public boolean hasValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return false;
        }
        Object value2 = nameValue.getValueAsObject();
        return value2 != null;
    }

    @Override
    public String getValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        Object value2 = nameValue.getValueAsObject();
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        return value2.toString();
    }

    @Override
    public void setValue(String value2) throws SdpException {
        if (value2 == null) {
            throw new SdpException("The value is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValueAsObject(value2);
        this.setAttribute(nameValue);
    }

    public void setValueAllowNull(String value2) {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValueAsObject(value2);
        this.setAttribute(nameValue);
    }

    @Override
    public Object clone() {
        AttributeField retval = (AttributeField)super.clone();
        if (this.attribute != null) {
            retval.attribute = (NameValue)this.attribute.clone();
        }
        return retval;
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof AttributeField)) {
            return false;
        }
        AttributeField other = (AttributeField)that;
        return other.getAttribute().getName().equalsIgnoreCase(this.getAttribute().getName()) && this.getAttribute().getValueAsObject().equals(other.getAttribute().getValueAsObject());
    }

    public int hashCode() {
        if (this.getAttribute() == null) {
            throw new UnsupportedOperationException("Attribute is null cannot compute hashCode ");
        }
        return this.encode().hashCode();
    }
}

