/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.PostParseExecutorServices;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.QueuedMessageDispatchBase;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class NioPipelineParser {
    private static StackLogger logger = CommonLogger.getLogger(NioPipelineParser.class);
    private static final String CRLF = "\r\n";
    protected SIPMessageListener sipMessageListener;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private MessageParser smp = null;
    boolean isRunning = false;
    boolean currentStreamEnded = false;
    boolean readingMessageBodyContents = false;
    boolean readingHeaderLines = true;
    boolean partialLineRead = false;
    String partialLine = "";
    String callId;
    private ConcurrentHashMap<String, CallIDOrderingStructure> messagesOrderingMap = new ConcurrentHashMap();
    StringBuffer message = new StringBuffer();
    byte[] messageBody = null;
    int contentLength = 0;
    int contentReadSoFar = 0;

    public void close() {
    }

    private void readStream(InputStream inputStream) throws IOException {
        boolean isPreviousLineCRLF = false;
        while (!this.currentStreamEnded) {
            if (this.readingHeaderLines) {
                isPreviousLineCRLF = this.readMessageSipHeaderLines(inputStream, isPreviousLineCRLF);
            }
            if (!this.readingMessageBodyContents) continue;
            this.readMessageBody(inputStream);
        }
    }

    private boolean readMessageSipHeaderLines(InputStream inputStream, boolean isPreviousLineCRLF) throws IOException {
        boolean crlfReceived = false;
        String line = this.readLine(inputStream);
        if (this.partialLineRead) {
            this.partialLine = this.partialLine + line;
        } else {
            line = this.partialLine + line;
            this.partialLine = "";
            if (!line.equals(CRLF)) {
                this.message.append(line);
                String lineIgnoreCase = line.toLowerCase();
                if (lineIgnoreCase.startsWith(ContentLength.NAME_LOWER)) {
                    this.contentLength = Integer.parseInt(line.substring(ContentLength.NAME_LOWER.length() + 1).trim());
                } else if (lineIgnoreCase.startsWith(CallID.NAME_LOWER)) {
                    this.callId = line.substring(CallID.NAME_LOWER.length() + 1).trim();
                }
            } else {
                if (isPreviousLineCRLF) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("KeepAlive Double CRLF received, sending single CRLF as defined per RFC 5626 Section 4.4.1");
                        logger.logDebug("~~~ setting isPreviousLineCRLF=false");
                    }
                    crlfReceived = false;
                    try {
                        this.sipMessageListener.sendSingleCLRF();
                    }
                    catch (Exception e) {
                        logger.logError("A problem occured while trying to send a single CLRF in response to a double CLRF", e);
                    }
                } else {
                    crlfReceived = true;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Received CRLF");
                    }
                    if (this.sipMessageListener != null && this.sipMessageListener instanceof ConnectionOrientedMessageChannel) {
                        ((ConnectionOrientedMessageChannel)this.sipMessageListener).cancelPingKeepAliveTimeoutTaskIfStarted();
                    }
                }
                if (this.message.length() > 0) {
                    this.readingMessageBodyContents = true;
                    this.readingHeaderLines = false;
                    this.partialLineRead = false;
                    this.message.append(CRLF);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Content Length parsed is " + this.contentLength);
                    }
                    this.contentReadSoFar = 0;
                    this.messageBody = new byte[this.contentLength];
                }
            }
        }
        return crlfReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessageBody(InputStream inputStream) throws IOException {
        int bytesRead = 0;
        if (this.contentLength > 0 && (bytesRead = this.readChunk(inputStream, this.messageBody, this.contentReadSoFar, this.contentLength - this.contentReadSoFar)) == -1) {
            this.currentStreamEnded = true;
            bytesRead = 0;
        }
        this.contentReadSoFar += bytesRead;
        if (this.contentReadSoFar == this.contentLength) {
            this.sizeCounter = this.maxMessageSize;
            this.readingHeaderLines = true;
            this.readingMessageBodyContents = false;
            String msgLines = this.message.toString();
            this.message = new StringBuffer();
            byte[] msgBodyBytes = this.messageBody;
            int finalContentLength = this.contentLength;
            if (PostParseExecutorServices.getPostParseExecutor() != null) {
                CallIDOrderingStructure newCallIDOrderingStructure;
                String callId = this.callId;
                if (callId == null || callId.trim().length() < 1) {
                    throw new IOException("received message with no Call-ID");
                }
                CallIDOrderingStructure orderingStructure = this.messagesOrderingMap.get(callId);
                if (orderingStructure == null && (orderingStructure = this.messagesOrderingMap.putIfAbsent(callId, newCallIDOrderingStructure = new CallIDOrderingStructure())) == null) {
                    orderingStructure = newCallIDOrderingStructure;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("new CallIDOrderingStructure added for message " + this.message);
                    }
                }
                CallIDOrderingStructure callIDOrderingStructure = orderingStructure;
                callIDOrderingStructure.getMessagesForCallID().offer(new UnparsedMessage(msgLines, msgBodyBytes));
                PostParseExecutorServices.getPostParseExecutor().execute(new Dispatch(callIDOrderingStructure, callId));
            } else {
                SIPMessage sipMessage = null;
                MessageParser messageParser = this.smp;
                synchronized (messageParser) {
                    try {
                        sipMessage = this.smp.parseSIPMessage(msgLines.getBytes(), false, false, null);
                        sipMessage.setMessageContent(msgBodyBytes);
                    }
                    catch (ParseException e) {
                        logger.logError("Parsing problem", e);
                    }
                }
                this.contentLength = 0;
                this.processSIPMessage(sipMessage);
            }
        }
    }

    public void processSIPMessage(SIPMessage message) {
        try {
            this.sipMessageListener.processMessage(message);
        }
        catch (Exception e) {
            logger.logError("Can't process message", e);
        }
    }

    public synchronized void addBytes(byte[] bytes) throws Exception {
        this.currentStreamEnded = false;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        this.readStream(inputStream);
    }

    protected NioPipelineParser() {
    }

    public NioPipelineParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.smp = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        this.sipMessageListener = sipMessageListener;
        this.sizeCounter = this.maxMessageSize = maxMessageSize;
    }

    public NioPipelineParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, int maxMsgSize) {
        this(sipStack, mhandler, false, maxMsgSize);
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private int readChunk(InputStream inputStream, byte[] where, int offset, int length) throws IOException {
        int read = inputStream.read(where, offset, length);
        this.sizeCounter -= read;
        this.checkLimits();
        return read;
    }

    private int readSingleByte(InputStream inputStream) throws IOException {
        --this.sizeCounter;
        this.checkLimits();
        return inputStream.read();
    }

    private void checkLimits() {
        if (this.maxMessageSize > 0 && this.sizeCounter < 0) {
            throw new RuntimeException("Max Message Size Exceeded " + this.maxMessageSize);
        }
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        this.partialLineRead = false;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        byte[] crlfBuffer = new byte[2];
        int crlfCounter = 0;
        while (true) {
            int i;
            if ((i = this.readSingleByte(inputStream)) == -1) {
                this.partialLineRead = true;
                this.currentStreamEnded = true;
                break;
            }
            char ch = (char)(i & 0xFF);
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            } else if (counter == 0) {
                crlfBuffer[crlfCounter++] = 13;
            }
            if (ch == '\n') {
                if (counter != 1 || crlfCounter <= 0) break;
                crlfBuffer[crlfCounter++] = 10;
                break;
            }
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        if (counter == 1 && crlfCounter > 0) {
            return new String(crlfBuffer, 0, crlfCounter, "UTF-8");
        }
        String lineRead = new String(lineBuffer, 0, counter, "UTF-8");
        if (crlfCounter == 1) {
            lineRead = lineRead + "\r";
        }
        return lineRead;
    }

    public class Dispatch
    implements Runnable,
    QueuedMessageDispatchBase {
        CallIDOrderingStructure callIDOrderingStructure;
        String callId;
        long time;

        public Dispatch(CallIDOrderingStructure callIDOrderingStructure, String callId) {
            this.callIDOrderingStructure = callIDOrderingStructure;
            this.callId = callId;
            this.time = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            SIPMessage parsedSIPMessage;
            block53: {
                Object object;
                Queue<UnparsedMessage> messagesForCallID;
                Semaphore semaphore;
                block52: {
                    semaphore = this.callIDOrderingStructure.getSemaphore();
                    messagesForCallID = this.callIDOrderingStructure.getMessagesForCallID();
                    try {
                        boolean acquired = semaphore.tryAcquire(30L, TimeUnit.SECONDS);
                        if (!acquired) {
                            if (logger.isLoggingEnabled(8)) {
                                logger.logWarning("Semaphore acquisition for callId " + this.callId + " wasn't successful so don't process message, returning");
                            }
                            return;
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("semaphore acquired for message " + this.callId + " acquired");
                        }
                    }
                    catch (InterruptedException e) {
                        logger.logError("Semaphore acquisition for callId " + this.callId + " interrupted, couldn't process message, returning", e);
                        return;
                    }
                    UnparsedMessage unparsedMessage = null;
                    parsedSIPMessage = null;
                    boolean messagePolled = false;
                    try {
                        object = NioPipelineParser.this.smp;
                        synchronized (object) {
                            unparsedMessage = messagesForCallID.peek();
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("\nUnparsed message before parser is:\n" + unparsedMessage);
                            }
                            if ((parsedSIPMessage = NioPipelineParser.this.smp.parseSIPMessage(unparsedMessage.lines.getBytes(), false, false, null)) == null) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("parsed message is null, probably because of end of stream, empty packets or socket closed and we got CRLF to terminate cleanly, not processing message");
                                }
                            } else if (unparsedMessage.body.length > 0) {
                                parsedSIPMessage.setMessageContent(unparsedMessage.body);
                            }
                        }
                        if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                            ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.beforeMessage(parsedSIPMessage);
                        }
                        messagesForCallID.poll();
                        messagePolled = true;
                        if (parsedSIPMessage != null) {
                            NioPipelineParser.this.sipMessageListener.processMessage(parsedSIPMessage);
                        }
                        if (messagePolled) break block52;
                        messagesForCallID.poll();
                    }
                    catch (ParseException e) {
                        if (logger.isLoggingEnabled(8)) {
                            logger.logWarning("Problem parsing message " + unparsedMessage);
                        }
                        break block53;
                    }
                    catch (Exception e2) {
                        block54: {
                            logger.logError("Error occured processing message " + NioPipelineParser.this.message, e2);
                            if (messagePolled) break block54;
                            messagesForCallID.poll();
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        if (messagesForCallID.size() <= 0) {
                            NioPipelineParser.this.messagesOrderingMap.remove(this.callId);
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("CallIDOrderingStructure removed for callId " + this.callId);
                            }
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("releasing semaphore for message " + parsedSIPMessage);
                        }
                        semaphore.release();
                        if (NioPipelineParser.this.messagesOrderingMap.isEmpty()) {
                            ConcurrentHashMap concurrentHashMap = NioPipelineParser.this.messagesOrderingMap;
                            synchronized (concurrentHashMap) {
                                NioPipelineParser.this.messagesOrderingMap.notify();
                            }
                        }
                        if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                            ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.afterMessage(parsedSIPMessage);
                        }
                        break block53;
                    }
                    finally {
                        if (!messagePolled) {
                            messagesForCallID.poll();
                        }
                        if (messagesForCallID.size() <= 0) {
                            NioPipelineParser.this.messagesOrderingMap.remove(this.callId);
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("CallIDOrderingStructure removed for callId " + this.callId);
                            }
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("releasing semaphore for message " + parsedSIPMessage);
                        }
                        semaphore.release();
                        if (NioPipelineParser.this.messagesOrderingMap.isEmpty()) {
                            ConcurrentHashMap e = NioPipelineParser.this.messagesOrderingMap;
                            synchronized (e) {
                                NioPipelineParser.this.messagesOrderingMap.notify();
                            }
                        }
                        if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                            ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.afterMessage(parsedSIPMessage);
                        }
                    }
                }
                if (messagesForCallID.size() <= 0) {
                    NioPipelineParser.this.messagesOrderingMap.remove(this.callId);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("CallIDOrderingStructure removed for callId " + this.callId);
                    }
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releasing semaphore for message " + parsedSIPMessage);
                }
                semaphore.release();
                if (NioPipelineParser.this.messagesOrderingMap.isEmpty()) {
                    object = NioPipelineParser.this.messagesOrderingMap;
                    synchronized (object) {
                        NioPipelineParser.this.messagesOrderingMap.notify();
                    }
                }
                if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                    ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.afterMessage(parsedSIPMessage);
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("dispatch task done on " + parsedSIPMessage);
            }
        }

        @Override
        public long getReceptionTime() {
            return this.time;
        }
    }

    public static class UnparsedMessage {
        String lines;
        byte[] body;

        public UnparsedMessage(String messageLines, byte[] body) {
            this.lines = messageLines;
            this.body = body;
        }

        public String toString() {
            return super.toString() + "\n" + this.lines;
        }
    }

    class CallIDOrderingStructure {
        private Semaphore semaphore = new Semaphore(1, true);
        private Queue<UnparsedMessage> messagesForCallID = new ConcurrentLinkedQueue<UnparsedMessage>();

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public Queue<UnparsedMessage> getMessagesForCallID() {
            return this.messagesForCallID;
        }
    }
}

