/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.spi.PlatformJarProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.PlatformLayersCacheManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Utilities;

class NbModuleProviderImpl
implements NbModuleProvider {
    private final NbModuleProject prj;

    NbModuleProviderImpl(NbModuleProject prj) {
        this.prj = prj;
    }

    public String getSpecVersion() {
        return this.prj.getSpecVersion();
    }

    public String getCodeNameBase() {
        return this.prj.getCodeNameBase();
    }

    public String getSourceDirectoryPath() {
        return this.prj.getSourceDirectoryPath();
    }

    public String getTestSourceDirectoryPath() {
        return this.getResourceDirectoryPath(true);
    }

    public FileObject getSourceDirectory() {
        return this.prj.getSourceDirectory();
    }

    public FileObject getManifestFile() {
        return this.prj.getManifestFile();
    }

    public String getResourceDirectoryPath(boolean inTests) {
        return this.prj.evaluator().getProperty(inTests ? "test.unit.src.dir" : "src.dir");
    }

    public void addDependencies(NbModuleProvider.ModuleDependency[] dependencies) throws IOException {
        for (NbModuleProvider.ModuleDependency dep : dependencies) {
            if (dep.isTestDependency()) {
                ApisupportAntUtils.addTestDependency(this.prj, dep.getCodeNameBase(), dep.getClusterName());
                continue;
            }
            ApisupportAntUtils.addDependency(this.prj, dep.getCodeNameBase(), dep.getReleaseVersion(), dep.getVersion(), dep.isUseInCompiler(), dep.getClusterName());
        }
    }

    public void addModulesToTargetPlatform(NbModuleProvider.ModuleDependency[] dependencies) throws IOException {
        Project suiteProject;
        if (this.prj.getModuleType() == NbModuleType.SUITE_COMPONENT && (suiteProject = ApisupportAntUtils.getSuiteProject(this.prj)) != null) {
            SuiteProperties suiteProps = ApisupportAntUtils.getSuiteProperties((SuiteProject)suiteProject);
            for (NbModuleProvider.ModuleDependency dep : dependencies) {
                boolean isClusterIncludedInTargetPlatform = ApisupportAntUtils.isClusterIncludedInTargetPlatform(suiteProps, dep.getClusterName());
                if (isClusterIncludedInTargetPlatform && !ApisupportAntUtils.isModuleIncludedInTargetPlatform(suiteProps, dep.getCodeNameBase())) {
                    ApisupportAntUtils.addModuleToTargetPlatform(suiteProject, suiteProps, dep.getCodeNameBase());
                    continue;
                }
                if (isClusterIncludedInTargetPlatform) continue;
                ApisupportAntUtils.addClusterToTargetPlatform(suiteProject, suiteProps, dep.getClusterName(), dep.getCodeNameBase());
            }
        }
    }

    public SpecificationVersion getDependencyVersion(String codenamebase) throws IOException {
        ModuleEntry entry = this.prj.getModuleList().getEntry(codenamebase);
        return entry != null ? new SpecificationVersion(entry.getSpecificationVersion()) : null;
    }

    public String getProjectFilePath() {
        return "nbproject/project.xml";
    }

    public File getModuleJarLocation() {
        return this.prj.getModuleJarLocation();
    }

    public boolean hasDependency(String codeNameBase) throws IOException {
        ProjectXMLManager pxm = new ProjectXMLManager(this.prj);
        for (ModuleDependency d : pxm.getDirectDependencies()) {
            if (!d.getModuleEntry().getCodeNameBase().equals(codeNameBase)) continue;
            return true;
        }
        return false;
    }

    public String getReleaseDirectoryPath() {
        return this.prj.evaluator().getProperty("release.dir");
    }

    public FileObject getReleaseDirectory() throws IOException {
        return FileUtil.createFolder((FileObject)this.prj.getProjectDirectory(), (String)this.getReleaseDirectoryPath());
    }

    public File getClassesDirectory() {
        return this.prj.getClassesDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileSystem getEffectiveSystemFilesystem() throws IOException {
        FileSystem projectLayer = LayerHandle.forProject((Project)this.prj).layer(false);
        switch (this.prj.getModuleType()) {
            case STANDALONE: {
                Set jars = ((PlatformJarProvider)this.prj.getLookup().lookup(PlatformJarProvider.class)).getPlatformJars();
                NbPlatform plaf = this.prj.getPlatform(true);
                Collection<FileSystem> platformLayers = this.getCachedLayers(plaf != null ? plaf.getDestDir() : null, jars);
                return LayerUtil.mergeFilesystems((FileSystem)projectLayer, platformLayers);
            }
            case SUITE_COMPONENT: {
                SuiteProject suite = SuiteUtils.findSuite(this.prj);
                if (suite == null) {
                    throw new IOException("Could not load suite for " + this.prj);
                }
                ArrayList<FileSystem> readOnlyLayers = new ArrayList<FileSystem>();
                Set<NbModuleProject> modules = SuiteUtils.getSubProjects(suite);
                for (NbModuleProject sister : modules) {
                    LayerHandle handle;
                    FileSystem roLayer;
                    if (sister == this.prj || (roLayer = (handle = LayerHandle.forProject((Project)sister)).layer(false)) == null) continue;
                    readOnlyLayers.add(roLayer);
                }
                NbPlatform plaf = suite.getPlatform(true);
                Set jars = ((PlatformJarProvider)suite.getLookup().lookup(PlatformJarProvider.class)).getPlatformJars();
                readOnlyLayers.addAll(this.getCachedLayers(plaf != null ? plaf.getDestDir() : null, jars));
                return LayerUtil.mergeFilesystems((FileSystem)projectLayer, readOnlyLayers);
            }
            case NETBEANS_ORG: {
                ArrayList<URL> otherLayerURLs = new ArrayList<URL>();
                for (NbModuleProject p2 : this.getProjectsForNetBeansOrgProject()) {
                    File layerXml;
                    FileObject layerXml2;
                    FileObject src;
                    if (p2.getManifest() == null) continue;
                    ManifestManager mm = ManifestManager.getInstance((Manifest)p2.getManifest(), (boolean)false, (boolean)true);
                    String layer = mm.getLayer();
                    if (layer != null && (src = p2.getSourceDirectory()) != null && (layerXml2 = src.getFileObject(layer)) != null) {
                        otherLayerURLs.add(layerXml2.toURL());
                    }
                    if ((layer = mm.getGeneratedLayer()) == null || !(layerXml = new File(this.getClassesDirectory(), layer)).isFile()) continue;
                    otherLayerURLs.add(Utilities.toURI((File)layerXml).toURL());
                }
                XMLFileSystem xfs = new XMLFileSystem();
                try {
                    xfs.setXmlUrls(otherLayerURLs.toArray(new URL[0]));
                    return LayerUtil.mergeFilesystems((FileSystem)projectLayer, Collections.singletonList(xfs));
                }
                catch (PropertyVetoException ex) {
                    assert (false) : ex;
                    return LayerUtil.mergeFilesystems((FileSystem)projectLayer, Collections.singletonList(xfs));
                }
            }
        }
        throw new AssertionError();
    }

    private Set<NbModuleProject> getProjectsForNetBeansOrgProject() throws IOException {
        ModuleList list = this.prj.getModuleList();
        HashSet<NbModuleProject> projects = new HashSet<NbModuleProject>();
        projects.add(this.prj);
        for (ModuleEntry other : list.getAllEntries()) {
            NbModuleProject p2;
            if (other.getClusterDirectory().getName().equals("extra")) continue;
            File root = other.getSourceLocation();
            assert (root != null) : other;
            FileObject fo = FileUtil.toFileObject((File)root);
            if (fo == null) continue;
            try {
                p2 = (NbModuleProject)ProjectManager.getDefault().findProject(fo);
            }
            catch (IOException x) {
                Logger.getLogger(NbModuleProject.class.getName()).log(Level.INFO, "could not load " + fo, x);
                continue;
            }
            if (p2 == null) continue;
            projects.add(p2);
        }
        return projects;
    }

    private Collection<FileSystem> getCachedLayers(File rootDir, final Set<File> platformJars) throws IOException {
        if (rootDir == null) {
            return Collections.emptySet();
        }
        File[] clusters = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return ClusterUtils.isValidCluster(pathname);
            }
        });
        Collection<FileSystem> cache = PlatformLayersCacheManager.getCache(clusters, new FileFilter(){

            @Override
            public boolean accept(File jar) {
                return platformJars.contains(jar);
            }
        });
        return cache;
    }
}

