/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.refactoring.ReferringClass;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

class MavenRefactoringElementImplementation
implements RefactoringElementImplementation {
    private static final Logger LOG = Logger.getLogger(MavenRefactoringElementImplementation.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(MavenRefactoringElementImplementation.class);
    private final ReferringClass ref;
    private FileObject file;
    private static final FileObject NO_FILE = FileUtil.getConfigRoot();

    MavenRefactoringElementImplementation(ReferringClass ref) {
        this.ref = ref;
    }

    public String getText() {
        return this.ref.clazz;
    }

    public String getDisplayText() {
        return TreeElementFactory.getTreeElement((Object)this.ref.artifact).getText(true);
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    public void performChange() {
    }

    public void undoChange() {
    }

    public Lookup getLookup() {
        return Lookups.singleton((Object)this.ref);
    }

    public synchronized FileObject getParentFile() {
        if (this.file == null) {
            try {
                URL jarURL;
                Artifact a = RepositoryUtil.createArtifact((NBVersionInfo)this.ref.artifact);
                File jar = a.getFile();
                if (!jar.exists()) {
                    jar = RepositoryUtil.downloadArtifact((NBVersionInfo)this.ref.artifact);
                }
                if ((jarURL = FileUtil.urlForArchiveOrDir((File)jar)) != null) {
                    SourceForBinaryQuery.Result2 result = SourceForBinaryQuery.findSourceRoots2((URL)jarURL);
                    if (result.preferSources()) {
                        FileObject[] roots;
                        for (FileObject root : roots = result.getRoots()) {
                            this.file = root.getFileObject(this.ref.clazz.replace('.', '/') + ".java");
                            if (this.file == null) continue;
                            LOG.log(Level.FINE, "found source file {0}", this.file);
                            break;
                        }
                        if (this.file == null) {
                            if (roots.length > 0) {
                                LOG.log(Level.WARNING, "did not find {0} among {1}", new Object[]{this.ref.clazz, Arrays.asList(roots)});
                            } else {
                                LOG.log(Level.FINE, "no source roots for {0}", jar);
                            }
                        }
                    } else {
                        LOG.log(Level.FINE, "ignoring non-preferred sources for {0}", jar);
                    }
                } else {
                    LOG.log(Level.WARNING, "no URL for {0}", jar);
                }
                if (this.file == null) {
                    if (jar.isFile()) {
                        this.file = URLMapper.findFileObject((URL)new URL("jar:" + jar.toURI() + "!/" + this.ref.clazz.replace('.', '/') + ".class"));
                        if (this.file == null) {
                            LOG.log(Level.WARNING, "did not find {0} in {1}", new Object[]{this.ref.clazz, jar});
                        }
                    } else {
                        LOG.log(Level.WARNING, "{0} does not exist", jar);
                    }
                }
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, null, x);
            }
            if (this.file == null) {
                this.file = NO_FILE;
            }
        }
        return this.file;
    }

    public PositionBounds getPosition() {
        return null;
    }

    public int getStatus() {
        return 0;
    }

    public void setStatus(int status) {
    }

    public void openInEditor() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileObject f = MavenRefactoringElementImplementation.this.getParentFile();
                if (f == NO_FILE) {
                    return;
                }
                if (f.hasExt("class")) {
                    try {
                        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
                        Artifact sources = online.createArtifactWithClassifier(((MavenRefactoringElementImplementation)MavenRefactoringElementImplementation.this).ref.artifact.getGroupId(), ((MavenRefactoringElementImplementation)MavenRefactoringElementImplementation.this).ref.artifact.getArtifactId(), ((MavenRefactoringElementImplementation)MavenRefactoringElementImplementation.this).ref.artifact.getVersion(), ((MavenRefactoringElementImplementation)MavenRefactoringElementImplementation.this).ref.artifact.getType(), "sources");
                        List remotes = RepositoryPreferences.getInstance().remoteRepositories(online);
                        online.resolveArtifact(sources, remotes, online.getLocalRepository());
                    }
                    catch (AbstractArtifactResolutionException x) {
                        LOG.log(Level.FINE, null, x);
                    }
                }
                try {
                    Openable o = (Openable)DataObject.find((FileObject)f).getLookup().lookup(Openable.class);
                    if (o != null) {
                        o.open();
                    } else {
                        LOG.log(Level.WARNING, "no Openable on {0}", MavenRefactoringElementImplementation.this.getParentFile());
                    }
                }
                catch (DataObjectNotFoundException x) {
                    LOG.log(Level.WARNING, null, x);
                }
            }
        });
    }

    public void showPreview() {
    }
}

