/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.model.BucketSummary;
import com.oracle.bmc.objectstorage.model.MultipartUpload;
import com.oracle.bmc.objectstorage.model.MultipartUploadPartSummary;
import com.oracle.bmc.objectstorage.model.ObjectSummary;
import com.oracle.bmc.objectstorage.model.ObjectVersionSummary;
import com.oracle.bmc.objectstorage.model.PreauthenticatedRequestSummary;
import com.oracle.bmc.objectstorage.model.ReplicationPolicySummary;
import com.oracle.bmc.objectstorage.model.ReplicationSource;
import com.oracle.bmc.objectstorage.model.RetentionRuleSummary;
import com.oracle.bmc.objectstorage.model.WorkRequestError;
import com.oracle.bmc.objectstorage.model.WorkRequestLogEntry;
import com.oracle.bmc.objectstorage.model.WorkRequestSummary;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectVersionsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationPoliciesRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationSourcesRequest;
import com.oracle.bmc.objectstorage.requests.ListRetentionRulesRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectVersionsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationPoliciesResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationSourcesResponse;
import com.oracle.bmc.objectstorage.responses.ListRetentionRulesResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectStoragePaginators {
    private final ObjectStorage client;

    public ObjectStoragePaginators(ObjectStorage client) {
        this.client = client;
    }

    public Iterable<ListBucketsResponse> listBucketsResponseIterator(final ListBucketsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBucketsRequest.Builder>(){

            @Override
            public ListBucketsRequest.Builder get() {
                return ListBucketsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBucketsResponse, String>(){

            @Override
            public String apply(ListBucketsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBucketsRequest.Builder>, ListBucketsRequest>(){

            @Override
            public ListBucketsRequest apply(RequestBuilderAndToken<ListBucketsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBucketsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBucketsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBucketsRequest, ListBucketsResponse>(){

            @Override
            public ListBucketsResponse apply(ListBucketsRequest request) {
                return ObjectStoragePaginators.this.client.listBuckets(request);
            }
        });
    }

    public Iterable<BucketSummary> listBucketsRecordIterator(final ListBucketsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBucketsRequest.Builder>(){

            @Override
            public ListBucketsRequest.Builder get() {
                return ListBucketsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBucketsResponse, String>(){

            @Override
            public String apply(ListBucketsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBucketsRequest.Builder>, ListBucketsRequest>(){

            @Override
            public ListBucketsRequest apply(RequestBuilderAndToken<ListBucketsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBucketsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBucketsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBucketsRequest, ListBucketsResponse>(){

            @Override
            public ListBucketsResponse apply(ListBucketsRequest request) {
                return ObjectStoragePaginators.this.client.listBuckets(request);
            }
        }, (Function)new Function<ListBucketsResponse, List<BucketSummary>>(){

            @Override
            public List<BucketSummary> apply(ListBucketsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMultipartUploadPartsResponse> listMultipartUploadPartsResponseIterator(final ListMultipartUploadPartsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMultipartUploadPartsRequest.Builder>(){

            @Override
            public ListMultipartUploadPartsRequest.Builder get() {
                return ListMultipartUploadPartsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadPartsResponse, String>(){

            @Override
            public String apply(ListMultipartUploadPartsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder>, ListMultipartUploadPartsRequest>(){

            @Override
            public ListMultipartUploadPartsRequest apply(RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(){

            @Override
            public ListMultipartUploadPartsResponse apply(ListMultipartUploadPartsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploadParts(request);
            }
        });
    }

    public Iterable<MultipartUploadPartSummary> listMultipartUploadPartsRecordIterator(final ListMultipartUploadPartsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMultipartUploadPartsRequest.Builder>(){

            @Override
            public ListMultipartUploadPartsRequest.Builder get() {
                return ListMultipartUploadPartsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadPartsResponse, String>(){

            @Override
            public String apply(ListMultipartUploadPartsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder>, ListMultipartUploadPartsRequest>(){

            @Override
            public ListMultipartUploadPartsRequest apply(RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(){

            @Override
            public ListMultipartUploadPartsResponse apply(ListMultipartUploadPartsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploadParts(request);
            }
        }, (Function)new Function<ListMultipartUploadPartsResponse, List<MultipartUploadPartSummary>>(){

            @Override
            public List<MultipartUploadPartSummary> apply(ListMultipartUploadPartsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMultipartUploadsResponse> listMultipartUploadsResponseIterator(final ListMultipartUploadsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMultipartUploadsRequest.Builder>(){

            @Override
            public ListMultipartUploadsRequest.Builder get() {
                return ListMultipartUploadsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadsResponse, String>(){

            @Override
            public String apply(ListMultipartUploadsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadsRequest.Builder>, ListMultipartUploadsRequest>(){

            @Override
            public ListMultipartUploadsRequest apply(RequestBuilderAndToken<ListMultipartUploadsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(){

            @Override
            public ListMultipartUploadsResponse apply(ListMultipartUploadsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploads(request);
            }
        });
    }

    public Iterable<MultipartUpload> listMultipartUploadsRecordIterator(final ListMultipartUploadsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMultipartUploadsRequest.Builder>(){

            @Override
            public ListMultipartUploadsRequest.Builder get() {
                return ListMultipartUploadsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadsResponse, String>(){

            @Override
            public String apply(ListMultipartUploadsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadsRequest.Builder>, ListMultipartUploadsRequest>(){

            @Override
            public ListMultipartUploadsRequest apply(RequestBuilderAndToken<ListMultipartUploadsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(){

            @Override
            public ListMultipartUploadsResponse apply(ListMultipartUploadsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploads(request);
            }
        }, (Function)new Function<ListMultipartUploadsResponse, List<MultipartUpload>>(){

            @Override
            public List<MultipartUpload> apply(ListMultipartUploadsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListObjectVersionsResponse> listObjectVersionsResponseIterator(final ListObjectVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListObjectVersionsRequest.Builder>(){

            @Override
            public ListObjectVersionsRequest.Builder get() {
                return ListObjectVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectVersionsResponse, String>(){

            @Override
            public String apply(ListObjectVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectVersionsRequest.Builder>, ListObjectVersionsRequest>(){

            @Override
            public ListObjectVersionsRequest apply(RequestBuilderAndToken<ListObjectVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListObjectVersionsRequest, ListObjectVersionsResponse>(){

            @Override
            public ListObjectVersionsResponse apply(ListObjectVersionsRequest request) {
                return ObjectStoragePaginators.this.client.listObjectVersions(request);
            }
        });
    }

    public Iterable<ObjectVersionSummary> listObjectVersionsRecordIterator(final ListObjectVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListObjectVersionsRequest.Builder>(){

            @Override
            public ListObjectVersionsRequest.Builder get() {
                return ListObjectVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectVersionsResponse, String>(){

            @Override
            public String apply(ListObjectVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectVersionsRequest.Builder>, ListObjectVersionsRequest>(){

            @Override
            public ListObjectVersionsRequest apply(RequestBuilderAndToken<ListObjectVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListObjectVersionsRequest, ListObjectVersionsResponse>(){

            @Override
            public ListObjectVersionsResponse apply(ListObjectVersionsRequest request) {
                return ObjectStoragePaginators.this.client.listObjectVersions(request);
            }
        }, (Function)new Function<ListObjectVersionsResponse, List<ObjectVersionSummary>>(){

            @Override
            public List<ObjectVersionSummary> apply(ListObjectVersionsResponse response) {
                return response.getObjectVersionCollection().getItems();
            }
        });
    }

    public Iterable<ListObjectsResponse> listObjectsResponseIterator(final ListObjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListObjectsRequest.Builder>(){

            @Override
            public ListObjectsRequest.Builder get() {
                return ListObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectsResponse, String>(){

            @Override
            public String apply(ListObjectsResponse response) {
                return response.getListObjects().getNextStartWith();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectsRequest.Builder>, ListObjectsRequest>(){

            @Override
            public ListObjectsRequest apply(RequestBuilderAndToken<ListObjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectsRequest.Builder)input.getRequestBuilder()).start(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListObjectsRequest, ListObjectsResponse>(){

            @Override
            public ListObjectsResponse apply(ListObjectsRequest request) {
                return ObjectStoragePaginators.this.client.listObjects(request);
            }
        });
    }

    public Iterable<ObjectSummary> listObjectsRecordIterator(final ListObjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListObjectsRequest.Builder>(){

            @Override
            public ListObjectsRequest.Builder get() {
                return ListObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectsResponse, String>(){

            @Override
            public String apply(ListObjectsResponse response) {
                return response.getListObjects().getNextStartWith();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectsRequest.Builder>, ListObjectsRequest>(){

            @Override
            public ListObjectsRequest apply(RequestBuilderAndToken<ListObjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectsRequest.Builder)input.getRequestBuilder()).start(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListObjectsRequest, ListObjectsResponse>(){

            @Override
            public ListObjectsResponse apply(ListObjectsRequest request) {
                return ObjectStoragePaginators.this.client.listObjects(request);
            }
        }, (Function)new Function<ListObjectsResponse, List<ObjectSummary>>(){

            @Override
            public List<ObjectSummary> apply(ListObjectsResponse response) {
                return response.getListObjects().getObjects();
            }
        });
    }

    public Iterable<ListPreauthenticatedRequestsResponse> listPreauthenticatedRequestsResponseIterator(final ListPreauthenticatedRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPreauthenticatedRequestsRequest.Builder>(){

            @Override
            public ListPreauthenticatedRequestsRequest.Builder get() {
                return ListPreauthenticatedRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPreauthenticatedRequestsResponse, String>(){

            @Override
            public String apply(ListPreauthenticatedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder>, ListPreauthenticatedRequestsRequest>(){

            @Override
            public ListPreauthenticatedRequestsRequest apply(RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(){

            @Override
            public ListPreauthenticatedRequestsResponse apply(ListPreauthenticatedRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listPreauthenticatedRequests(request);
            }
        });
    }

    public Iterable<PreauthenticatedRequestSummary> listPreauthenticatedRequestsRecordIterator(final ListPreauthenticatedRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPreauthenticatedRequestsRequest.Builder>(){

            @Override
            public ListPreauthenticatedRequestsRequest.Builder get() {
                return ListPreauthenticatedRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPreauthenticatedRequestsResponse, String>(){

            @Override
            public String apply(ListPreauthenticatedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder>, ListPreauthenticatedRequestsRequest>(){

            @Override
            public ListPreauthenticatedRequestsRequest apply(RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(){

            @Override
            public ListPreauthenticatedRequestsResponse apply(ListPreauthenticatedRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listPreauthenticatedRequests(request);
            }
        }, (Function)new Function<ListPreauthenticatedRequestsResponse, List<PreauthenticatedRequestSummary>>(){

            @Override
            public List<PreauthenticatedRequestSummary> apply(ListPreauthenticatedRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReplicationPoliciesResponse> listReplicationPoliciesResponseIterator(final ListReplicationPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicationPoliciesRequest.Builder>(){

            @Override
            public ListReplicationPoliciesRequest.Builder get() {
                return ListReplicationPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationPoliciesResponse, String>(){

            @Override
            public String apply(ListReplicationPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder>, ListReplicationPoliciesRequest>(){

            @Override
            public ListReplicationPoliciesRequest apply(RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse>(){

            @Override
            public ListReplicationPoliciesResponse apply(ListReplicationPoliciesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationPolicies(request);
            }
        });
    }

    public Iterable<ReplicationPolicySummary> listReplicationPoliciesRecordIterator(final ListReplicationPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicationPoliciesRequest.Builder>(){

            @Override
            public ListReplicationPoliciesRequest.Builder get() {
                return ListReplicationPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationPoliciesResponse, String>(){

            @Override
            public String apply(ListReplicationPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder>, ListReplicationPoliciesRequest>(){

            @Override
            public ListReplicationPoliciesRequest apply(RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse>(){

            @Override
            public ListReplicationPoliciesResponse apply(ListReplicationPoliciesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationPolicies(request);
            }
        }, (Function)new Function<ListReplicationPoliciesResponse, List<ReplicationPolicySummary>>(){

            @Override
            public List<ReplicationPolicySummary> apply(ListReplicationPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReplicationSourcesResponse> listReplicationSourcesResponseIterator(final ListReplicationSourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicationSourcesRequest.Builder>(){

            @Override
            public ListReplicationSourcesRequest.Builder get() {
                return ListReplicationSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationSourcesResponse, String>(){

            @Override
            public String apply(ListReplicationSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationSourcesRequest.Builder>, ListReplicationSourcesRequest>(){

            @Override
            public ListReplicationSourcesRequest apply(RequestBuilderAndToken<ListReplicationSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationSourcesRequest, ListReplicationSourcesResponse>(){

            @Override
            public ListReplicationSourcesResponse apply(ListReplicationSourcesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationSources(request);
            }
        });
    }

    public Iterable<ReplicationSource> listReplicationSourcesRecordIterator(final ListReplicationSourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicationSourcesRequest.Builder>(){

            @Override
            public ListReplicationSourcesRequest.Builder get() {
                return ListReplicationSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationSourcesResponse, String>(){

            @Override
            public String apply(ListReplicationSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationSourcesRequest.Builder>, ListReplicationSourcesRequest>(){

            @Override
            public ListReplicationSourcesRequest apply(RequestBuilderAndToken<ListReplicationSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationSourcesRequest, ListReplicationSourcesResponse>(){

            @Override
            public ListReplicationSourcesResponse apply(ListReplicationSourcesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationSources(request);
            }
        }, (Function)new Function<ListReplicationSourcesResponse, List<ReplicationSource>>(){

            @Override
            public List<ReplicationSource> apply(ListReplicationSourcesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRetentionRulesResponse> listRetentionRulesResponseIterator(final ListRetentionRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRetentionRulesRequest.Builder>(){

            @Override
            public ListRetentionRulesRequest.Builder get() {
                return ListRetentionRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRetentionRulesResponse, String>(){

            @Override
            public String apply(ListRetentionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRetentionRulesRequest.Builder>, ListRetentionRulesRequest>(){

            @Override
            public ListRetentionRulesRequest apply(RequestBuilderAndToken<ListRetentionRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRetentionRulesRequest, ListRetentionRulesResponse>(){

            @Override
            public ListRetentionRulesResponse apply(ListRetentionRulesRequest request) {
                return ObjectStoragePaginators.this.client.listRetentionRules(request);
            }
        });
    }

    public Iterable<RetentionRuleSummary> listRetentionRulesRecordIterator(final ListRetentionRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRetentionRulesRequest.Builder>(){

            @Override
            public ListRetentionRulesRequest.Builder get() {
                return ListRetentionRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRetentionRulesResponse, String>(){

            @Override
            public String apply(ListRetentionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRetentionRulesRequest.Builder>, ListRetentionRulesRequest>(){

            @Override
            public ListRetentionRulesRequest apply(RequestBuilderAndToken<ListRetentionRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRetentionRulesRequest, ListRetentionRulesResponse>(){

            @Override
            public ListRetentionRulesResponse apply(ListRetentionRulesRequest request) {
                return ObjectStoragePaginators.this.client.listRetentionRules(request);
            }
        }, (Function)new Function<ListRetentionRulesResponse, List<RetentionRuleSummary>>(){

            @Override
            public List<RetentionRuleSummary> apply(ListRetentionRulesResponse response) {
                return response.getRetentionRuleCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

