/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.breakpoints.ExceptionBreakpoint;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.Reason;
import org.netbeans.modules.php.dbgp.packets.Status;
import org.netbeans.modules.php.dbgp.packets.StatusResponse;
import org.w3c.dom.Node;

public class RunResponse
extends StatusResponse {
    private static final String BREAKPOINT = "breakpoint";
    private static final String BREAKPOINT_ID = "id";
    private static final String MESSAGE = "xdebug:message";
    private static final String CODE = "code";

    RunResponse(Node node) {
        super(node);
    }

    @Override
    public void process(DebugSession dbgSession, DbgpCommand command) {
        String id;
        Node breakpoint;
        Status status = this.getStatus();
        Reason reason = this.getReason();
        if (status != null && reason != null) {
            dbgSession.processStatus(status, reason, command);
        }
        Node message = RunResponse.getChild(this.getNode(), MESSAGE);
        String code = null;
        if (message != null) {
            code = RunResponse.getAttribute(message, CODE);
        }
        if ((breakpoint = RunResponse.getChild(this.getNode(), BREAKPOINT)) != null && (id = DbgpMessage.getAttribute(breakpoint, BREAKPOINT_ID)) != null) {
            this.setCurrentBreakpoint(dbgSession, id);
            if (message != null) {
                this.setCurrentBreakpointText(dbgSession, message.getTextContent(), code);
            }
        }
    }

    private void setCurrentBreakpoint(DebugSession session, String id) {
        BreakpointModel breakpointModel;
        DebugSession.IDESessionBridge bridge = session.getBridge();
        if (bridge != null && (breakpointModel = bridge.getBreakpointModel()) != null && breakpointModel.isSearchCurrentBreakpointById()) {
            breakpointModel.setCurrentBreakpoint(session, id);
        }
    }

    private void setCurrentBreakpointText(DebugSession session, String message, String code) {
        AbstractBreakpoint bp;
        BreakpointModel breakpointModel;
        DebugSession.IDESessionBridge bridge = session.getBridge();
        if (bridge != null && (breakpointModel = bridge.getBreakpointModel()) != null && breakpointModel.isSearchCurrentBreakpointById() && (bp = breakpointModel.getCurrentBreakpoint(session)) instanceof ExceptionBreakpoint) {
            ((ExceptionBreakpoint)bp).setExceptionMessage(message);
            ((ExceptionBreakpoint)bp).setExceptionCode(code);
        }
    }
}

