/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.openide.actions.FileSystemAction;
import org.openide.awt.UndoRedo;
import org.openide.util.actions.SystemAction;

public abstract class AbstractMultiViewElement
implements MultiViewElement,
Serializable {
    private static final long serialVersionUID = 20110816L;
    private static final Logger LOGGER = Logger.getLogger(AbstractMultiViewElement.class.getName());
    protected XmlMultiViewDataObject dObj;
    protected transient MultiViewElementCallback callback;

    protected AbstractMultiViewElement() {
    }

    protected AbstractMultiViewElement(XmlMultiViewDataObject dObj) {
        this.dObj = dObj;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        XmlMultiViewEditorSupport support;
        this.callback = callback;
        if (this.dObj != null && (support = this.dObj.getEditorSupport()) != null) {
            support.setMVTC(callback.getTopComponent());
            support.updateDisplayName();
        }
    }

    public CloseOperationState canCloseElement() {
        if (this.dObj == null || this.dObj.canClose()) {
            return CloseOperationState.STATE_OK;
        }
        if (!this.callback.isSelectedElement()) {
            return CloseOperationState.STATE_OK;
        }
        if (!this.dObj.isModified()) {
            return CloseOperationState.STATE_OK;
        }
        boolean differ = false;
        String message = this.dObj.getEditorSupport().messageSave();
        try {
            String encoding = this.dObj.encoding();
            differ = this.dObj.encodingDiffer(encoding);
            if (differ) {
                message = message + " <b>" + this.dObj.encodingMessage(encoding) + "</b>";
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        message = "<html>" + message + "</html>";
        return MultiViewFactory.createUnsafeCloseState((String)message, (Action)new SaveAction(differ), (Action)new DiscardAction());
    }

    public Action[] getActions() {
        Action[] actions = this.callback.createDefaultActions();
        SystemAction fsAction = SystemAction.get(FileSystemAction.class);
        if (!Arrays.asList(actions).contains(fsAction)) {
            Action[] newActions = new Action[actions.length + 1];
            System.arraycopy(actions, 0, newActions, 0, actions.length);
            newActions[actions.length] = fsAction;
            actions = newActions;
        }
        return actions;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public UndoRedo getUndoRedo() {
        return this.dObj == null ? null : this.dObj.getEditorSupport().getUndoRedo0();
    }

    private class SaveAction
    extends AbstractAction {
        private final boolean encodingReset;

        public SaveAction(boolean encodingReset) {
            this.encodingReset = encodingReset;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.encodingReset) {
                AbstractMultiViewElement.this.dObj.encodingReset();
            }
            try {
                AbstractMultiViewElement.this.dObj.getEditorSupport().onCloseSave();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private class DiscardAction
    extends AbstractAction {
        private DiscardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractMultiViewElement.this.dObj.getEditorSupport().onCloseDiscard();
        }
    }
}

