/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProvider;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProviders;
import org.netbeans.modules.selenium2.webclient.ui.actions.Bundle;
import org.netbeans.modules.selenium2.webclient.ui.actions.RunSeleniumAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DebugSeleniumAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor RP = new RequestProcessor(RunSeleniumAction.class.getName(), 1);
    private FileObject[] activatedFOs;

    public DebugSeleniumAction() {
        this(Utilities.actionsGlobalContext());
    }

    private DebugSeleniumAction(Lookup actionContext) {
        this.activatedFOs = this.lookupSeleniumTestOnly(actionContext);
        if (this.activatedFOs != null) {
            this.putValue("Name", Bundle.SeleniumDebugTestFileAction_name());
        }
        this.putValue("hideWhenDisabled", true);
        this.setEnabled(this.activatedFOs != null);
    }

    @Override
    public boolean isEnabled() {
        return this.activatedFOs != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Project p = FileOwnerQuery.getOwner((FileObject)DebugSeleniumAction.this.activatedFOs[0]);
                if (p == null) {
                    return;
                }
                SeleniumTestingProvider provider = SeleniumTestingProviders.getDefault().getSeleniumTestingProvider(p, true);
                if (provider != null) {
                    provider.debugTests(DebugSeleniumAction.this.activatedFOs);
                }
            }
        });
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DebugSeleniumAction(actionContext);
    }

    @CheckForNull
    private FileObject[] lookupSeleniumTestOnly(Lookup context) {
        Collection fileObjects = context.lookupAll(FileObject.class);
        if (fileObjects.size() != 1) {
            return null;
        }
        FileObject fo = (FileObject)fileObjects.iterator().next();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("HTML5-Tests-Selenium");
        if (sourceGroups.length != 1) {
            return null;
        }
        FileObject rootFolder = sourceGroups[0].getRootFolder();
        if (!FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fo)) {
            return null;
        }
        return new FileObject[]{fo};
    }
}

