/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.netbeans.modules.project.dependency.Dependency;

public class DependencyText {
    boolean single;
    String configuration;
    String keyword;
    boolean custom;
    int startPos;
    int endPos;
    List<Part> partList = new ArrayList<Part>();
    String contents;
    String group;
    String name;
    String version;
    Style style;
    Container container;
    static final String KEYWORD_PROJECT = "project";

    public DependencyText(String container, int startPos) {
        this.configuration = container;
        this.startPos = startPos;
    }

    public String getProjectPath() {
        return KEYWORD_PROJECT.equals(this.keyword) ? this.contents : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.configuration).append(" += ");
        if (this.keyword != null) {
            sb.append(this.keyword).append("(");
            if (!this.partList.isEmpty()) {
                sb.append(this.partList.stream().map(p -> p.value).collect(Collectors.joining(", ")));
            } else if (this.contents != null) {
                sb.append(this.contents);
            }
            sb.append(")");
        } else if (this.contents != null) {
            sb.append(this.contents);
        } else {
            sb.append(this.partList.stream().map(p -> p.toString()).collect(Collectors.joining(", ")));
        }
        sb.append(" [").append(this.startPos).append(", ").append(this.endPos).append("]}");
        return sb.toString();
    }

    static String stripStrict(String s) {
        if (!s.endsWith("!!")) {
            return s;
        }
        return s.substring(0, s.length() - 2);
    }

    public String getContentsOrGav() {
        if (this.contents != null) {
            return this.contents;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.group).append(':').append(this.name);
        if (this.version != null && !this.version.isEmpty()) {
            sb.append(":").append(DependencyText.stripStrict(this.version));
        }
        return sb.toString();
    }

    public static final class Part {
        String partId;
        int startPos;
        String value;
        int endPos;
        int quoted;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.partId != null) {
                sb.append(this.partId).append(": ");
            }
            sb.append(this.value);
            sb.append(" [").append(this.startPos).append(", ").append(this.endPos).append("]");
            return sb.toString();
        }
    }

    public static final class Mapping {
        private final Map<Dependency, DependencyText> textMapping;
        private final Part container;

        public Mapping(Map<Dependency, DependencyText> textMapping, Part container) {
            this.textMapping = textMapping;
            this.container = container;
        }

        public Part getText(Dependency d, String part) {
            if (d == null && "container".equals(part)) {
                return this.container;
            }
            DependencyText t = this.textMapping.get(d);
            if (t == null) {
                return null;
            }
            if (part == null) {
                Part p = new Part();
                p.startPos = t.startPos;
                p.endPos = t.endPos;
                p.value = t.contents;
                return p;
            }
            if ("container".equals(part)) {
                if (t.container != null) {
                    return t.container.containerPart;
                }
                return null;
            }
            for (Part p : t.partList) {
                if (!part.equals(p.partId)) continue;
                return p;
            }
            return null;
        }
    }

    public static final class Container {
        final List<DependencyText> items;
        final Part containerPart;

        public Container(List<DependencyText> items, Part containerPart) {
            this.items = items;
            this.containerPart = containerPart;
        }
    }

    public static enum Style {
        MAP_LITERAL,
        CUSTOMIZED,
        GAV_STRING,
        CONTAINER_ITEM,
        BRACKETS,
        PARENTHESIS;

    }
}

