/**
A type of AudioNode which operates as an audio source whose media is received from a MediaStream obtained using the WebRTC or Media Capture and Streams APIs.

@returns {MediaStreamAudioSourceNode}
*/
MediaStreamAudioSourceNode = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {MediaStream}
**/
MediaStreamAudioSourceNode.prototype.mediaStream = new MediaStream();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
MediaStreamAudioSourceNode.prototype.channelCount = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("clamped-max" | "explicit" | "max")} ChannelCountMode
**/
MediaStreamAudioSourceNode.prototype.channelCountMode = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("discrete" | "speakers")} ChannelInterpretation
**/
MediaStreamAudioSourceNode.prototype.channelInterpretation = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {BaseAudioContext}
**/
MediaStreamAudioSourceNode.prototype.context = new BaseAudioContext();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
MediaStreamAudioSourceNode.prototype.numberOfInputs = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
MediaStreamAudioSourceNode.prototype.numberOfOutputs = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {AudioParam} destinationParam AudioParam
@param {Number} [output]
@returns {undefined}
**/
MediaStreamAudioSourceNode.prototype.connect = function(destinationParam) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {AudioParam} destinationParam AudioParam
@param {Number} output
@returns {undefined}
**/
MediaStreamAudioSourceNode.prototype.disconnect = function(destinationParam, output) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
MediaStreamAudioSourceNode.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
MediaStreamAudioSourceNode.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
MediaStreamAudioSourceNode.prototype.removeEventListener = function(type, callback) {};

