<?php

namespace {

	/**
	 * Add two arbitrary precision numbers
	 * <p>Sums <code>num1</code> and <code>num2</code>.</p>
	 * @param string $num1 <p>The left operand, as a string.</p>
	 * @param string $num2 <p>The right operand, as a string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>The sum of the two operands, as a string.</p>
	 * @link https://php.net/manual/en/function.bcadd.php
	 * @see bcsub()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcadd(string $num1, string $num2, ?int $scale = null): string {}

	/**
	 * Round up arbitrary precision number
	 * <p>Returns the next highest integer value by rounding up <code>num</code> if necessary.</p>
	 * @param string $num The value to round.
	 * @return string <p>Returns a numeric string representing <code>num</code> rounded up to the nearest integer.</p>
	 * @link https://php.net/manual/en/function.bcceil.php
	 * @see bcfloor(), bcround()
	 * @since PHP 8 >= 8.4.0
	 */
	function bcceil(string $num): string {}

	/**
	 * Compare two arbitrary precision numbers
	 * <p>Compares <code>num1</code> to <code>num2</code> and returns the result of the comparison as an integer.</p>
	 * @param string $num1 <p>The left operand, as a string.</p>
	 * @param string $num2 <p>The right operand, as a string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return int <p>Returns <code>0</code> if both operands are equal, <code>1</code> if <code>num1</code> is greater than <code>num2</code>, <code>-1</code> otherwise.</p>
	 * @link https://php.net/manual/en/function.bccomp.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bccomp(string $num1, string $num2, ?int $scale = null): int {}

	/**
	 * Divide two arbitrary precision numbers
	 * <p>Divides <code>num1</code> by <code>num2</code>.</p>
	 * @param string $num1 <p>The dividend, as a string.</p>
	 * @param string $num2 <p>The divisor, as a string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>Returns the result of the division as a string.</p>
	 * @link https://php.net/manual/en/function.bcdiv.php
	 * @see bcdivmod(), bcmod(), bcmul()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcdiv(string $num1, string $num2, ?int $scale = null): string {}

	/**
	 * Get the quotient and modulus of an arbitrary precision number
	 * <p>Get the quotient and remainder of dividing <code>num1</code> by <code>num2</code>.</p>
	 * @param string $num1 <p>The dividend, as a string.</p>
	 * @param string $num2 <p>The divisor, as a string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>Returns an indexed <code>array</code> where the first element is the quotient as a <code>string</code> and the second element is the remainder as a <code>string</code>.</p>
	 * @link https://php.net/manual/en/function.bcdivmod.php
	 * @see bcdiv(), bcmod()
	 * @since PHP 8 >= 8.4.0
	 */
	function bcdivmod(string $num1, string $num2, ?int $scale = null): string {}

	/**
	 * Round down arbitrary precision number
	 * <p>Returns the next lowest integer value by rounding down <code>num</code> if necessary.</p>
	 * @param string $num The value to round.
	 * @return string <p>Returns a numeric string representing <code>num</code> rounded down to the nearest integer.</p>
	 * @link https://php.net/manual/en/function.bcfloor.php
	 * @see bcceil(), bcround()
	 * @since PHP 8 >= 8.4.0
	 */
	function bcfloor(string $num): string {}

	/**
	 * Get modulus of an arbitrary precision number
	 * <p>Get the remainder of dividing <code>num1</code> by <code>num2</code>. The result has the same sign as <code>num1</code>.</p>
	 * @param string $num1 <p>The left operand, as a string.</p>
	 * @param string $num2 <p>The right operand, as a string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>Returns the modulus as a string.</p>
	 * @link https://php.net/manual/en/function.bcmod.php
	 * @see bcdiv(), bcdivmod()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcmod(string $num1, string $num2, ?int $scale = null): string {}

	/**
	 * Multiply two arbitrary precision numbers
	 * <p>Multiply <code>num1</code> by <code>num2</code>.</p>
	 * @param string $num1 <p>The left operand, as a string.</p>
	 * @param string $num2 <p>The right operand, as a string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>Returns the result as a string.</p>
	 * @link https://php.net/manual/en/function.bcmul.php
	 * @see bcdiv()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcmul(string $num1, string $num2, ?int $scale = null): string {}

	/**
	 * Raise an arbitrary precision number to another
	 * <p>Raise <code>num</code> to the power <code>exponent</code>.</p>
	 * @param string $num <p>The base, as a string.</p>
	 * @param string $exponent <p>The exponent, as a string. Must be a value with no fractional part. The valid range of the exponent is platform specific, but is at least <code>-2147483648</code> to <code>2147483647</code>.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>Returns the result as a string.</p>
	 * @link https://php.net/manual/en/function.bcpow.php
	 * @see bcpowmod(), bcsqrt()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcpow(string $num, string $exponent, ?int $scale = null): string {}

	/**
	 * Raise an arbitrary precision number to another, reduced by a specified modulus
	 * <p>Use the fast-exponentiation method to raise <code>num</code> to the power <code>exponent</code> with respect to the modulus <code>modulus</code>.</p>
	 * @param string $num <p>The base, as an integral string (i.e. the scale has to be zero).</p>
	 * @param string $exponent <p>The exponent, as an non-negative, integral string (i.e. the scale has to be zero).</p>
	 * @param string $modulus <p>The modulus, as an integral string (i.e. the scale has to be zero).</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>Returns the result as a string.</p>
	 * @link https://php.net/manual/en/function.bcpowmod.php
	 * @see bcpow(), bcmod()
	 * @since PHP 5, PHP 7, PHP 8
	 */
	function bcpowmod(string $num, string $exponent, string $modulus, ?int $scale = null): string {}

	/**
	 * Round arbitrary precision number
	 * <p>Returns the rounded value of <code>num</code> to specified <code>precision</code> (number of digits after the decimal point). <code>precision</code> can also be negative or zero (default).</p>
	 * @param string $num <p>The value to round.</p>
	 * @param int $precision <p>The optional number of decimal digits to round to.</p> <p>If the <code>precision</code> is positive, <code>num</code> is rounded to <code>precision</code> significant digits after the decimal point.</p> <p>If the <code>precision</code> is negative, <code>num</code> is rounded to <code>precision</code> significant digits before the decimal point, i.e. to the nearest multiple of <code>pow(10, -$precision)</code>, e.g. for a <code>precision</code> of -1 <code>num</code> is rounded to tens, for a <code>precision</code> of -2 to hundreds, etc.</p>
	 * @param \RoundingMode $mode Specifies the rounding mode.
	 * @return string <p>Returns a numeric string representing <code>num</code> rounded to the given precision.</p>
	 * @link https://php.net/manual/en/function.bcround.php
	 * @see bcceil(), bcfloor()
	 * @since PHP 8 >= 8.4.0
	 */
	function bcround(string $num, int $precision = 0, \RoundingMode $mode = RoundingMode::HalfAwayFromZero): string {}

	/**
	 * Set or get default scale parameter for all bc math functions
	 * <p>Sets the default scale parameter for all subsequent calls to bc math functions that do not explicitly specify a scale parameter.</p><p>Gets the current scale factor.</p>
	 * @param int $scale <p>The scale factor.</p>
	 * @return int <p>Returns the old scale when used as setter. Otherwise the current scale is returned.</p>
	 * @link https://php.net/manual/en/function.bcscale.php
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcscale(int $scale): int {}

	/**
	 * Get the square root of an arbitrary precision number
	 * <p>Return the square root of <code>num</code>.</p>
	 * @param string $num <p>The operand, as a well-formed BCMath numeric string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>Returns the square root as a well-formed BCMath numeric string.</p>
	 * @link https://php.net/manual/en/function.bcsqrt.php
	 * @see bcpow()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcsqrt(string $num, ?int $scale = null): string {}

	/**
	 * Subtract one arbitrary precision number from another
	 * <p>Subtracts <code>num2</code> from <code>num1</code>.</p>
	 * @param string $num1 <p>The left operand, as a string.</p>
	 * @param string $num2 <p>The right operand, as a string.</p>
	 * @param ?int $scale This parameter is used to set the number of digits after the decimal place in the result. If <b><code>null</code></b>, it will default to the default scale set with <code>bcscale()</code>, or fallback to the value of the <code>bcmath.scale</code> INI directive.
	 * @return string <p>The result of the subtraction, as a string.</p>
	 * @link https://php.net/manual/en/function.bcsub.php
	 * @see bcadd()
	 * @since PHP 4, PHP 5, PHP 7, PHP 8
	 */
	function bcsub(string $num1, string $num2, ?int $scale = null): string {}

}
