/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.resolver.LoggerResolverFactory;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactoryConverter;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PaxPropertySource;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggerImpl;
import org.ops4j.pax.logging.log4j2.internal.bridges.PaxOsgiAppender;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.LogEntryImpl;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.FormatterLogger;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;

public class PaxLoggingServiceImpl
implements PaxLoggingService,
ServiceFactory<Object> {
    private static final String LOGGER_CONTEXT_NAME = "pax-logging";
    private final BundleContext m_bundleContext;
    private ReadWriteLock m_configLock;
    private final LogReaderServiceImpl m_logReader;
    private final PaxContext m_paxContext;
    private final EventAdminPoster m_eventAdmin;
    private final ConfigurationNotifier m_configNotifier;
    private LogLevel m_r7LogLevel = LogLevel.DEBUG;
    private LoggerContext m_log4jContext;
    private final AtomicBoolean emptyConfiguration = new AtomicBoolean(false);
    private volatile boolean closed;
    private volatile boolean errorsAsException = false;
    private final String fqcn = this.getClass().getName();
    private boolean m_async;
    private Dictionary<String, String> defaultConfiguration = null;

    public PaxLoggingServiceImpl(BundleContext bundleContext, LogReaderServiceImpl logReader, EventAdminPoster eventAdmin, ConfigurationNotifier configNotifier) {
        String errorsAsExceptionValue;
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.m_bundleContext = bundleContext;
        this.m_logReader = logReader;
        this.m_eventAdmin = eventAdmin;
        this.m_configNotifier = configNotifier;
        this.m_paxContext = new PaxContext();
        String useLocks = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.useLocks");
        if (!"false".equalsIgnoreCase(useLocks)) {
            this.m_configLock = new ReentrantReadWriteLock();
        }
        if ("true".equalsIgnoreCase(errorsAsExceptionValue = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.log4j2.errorsAsExceptions"))) {
            this.errorsAsException = true;
        }
    }

    public synchronized void shutdown() {
        StatusLogger.getLogger().reset();
        this.m_log4jContext.stop();
        this.closed = true;
    }

    void lock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().lock();
            } else {
                lock.readLock().lock();
            }
        }
    }

    void unlock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().unlock();
            } else {
                lock.readLock().unlock();
            }
        }
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        return this.getLogger(bundle, category, fqcn, false);
    }

    public LogLevel getLogLevel() {
        return this.m_r7LogLevel;
    }

    public void log(int level, String message) {
        this.logImpl(null, level, message, null, this.fqcn);
    }

    public void log(int level, String message, Throwable exception) {
        this.logImpl(null, level, message, exception, this.fqcn);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, null, this.fqcn);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, exception, this.fqcn);
    }

    public PaxContext getPaxContext() {
        return this.m_paxContext;
    }

    public org.osgi.service.log.Logger getLogger(String name) {
        return this.getLogger(null, name, PaxLoggerImpl.FQCN);
    }

    public org.osgi.service.log.Logger getLogger(Class<?> clazz) {
        return this.getLogger(null, clazz.getName(), PaxLoggerImpl.FQCN);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
        return this.getLogger(null, name, loggerType);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
        return this.getLogger(null, clazz.getName(), loggerType);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
        return this.getLogger(bundle, name, loggerType, PaxLoggerImpl.FQCN);
    }

    private <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType, String fqcn) {
        if (loggerType == org.osgi.service.log.Logger.class) {
            return (L)((org.osgi.service.log.Logger)loggerType.cast(this.getLogger(bundle, name, fqcn, false)));
        }
        if (loggerType == FormatterLogger.class) {
            return (L)((org.osgi.service.log.Logger)loggerType.cast(this.getLogger(bundle, name, fqcn, true)));
        }
        throw new IllegalArgumentException("Can't obtain logger with type " + loggerType);
    }

    private PaxLogger getLogger(Bundle bundle, String category, String fqcn, boolean printfFormatting) {
        org.apache.logging.log4j.core.Logger log4j2Logger = category == null ? this.m_log4jContext.getRootLogger() : this.m_log4jContext.getLogger(category);
        return new PaxLoggerImpl(bundle, (ExtendedLogger)log4j2Logger, fqcn, this, printfFormatting);
    }

    public void setDefaultConfiguration(Dictionary<String, String> config) {
        this.defaultConfiguration = config;
    }

    synchronized void updated(Dictionary<String, ?> configuration) {
        boolean async;
        Object useLocks;
        if (this.closed) {
            return;
        }
        if (configuration == null && this.defaultConfiguration == null) {
            this.configureDefaults();
            return;
        }
        if (configuration == null) {
            configuration = this.defaultConfiguration;
        }
        if (!"false".equalsIgnoreCase(String.valueOf(useLocks = configuration.get("org.ops4j.pax.logging.useLocks")))) {
            if (this.m_configLock == null) {
                this.m_configLock = new ReentrantReadWriteLock();
            }
        } else {
            this.m_configLock = null;
        }
        Object configfile = configuration.get("org.ops4j.pax.logging.log4j2.config.file");
        Object asyncProperty = configuration.get("org.ops4j.pax.logging.log4j2.async");
        boolean bl = async = asyncProperty != null && Boolean.parseBoolean(asyncProperty.toString());
        if (async) {
            try {
                this.getClass().getClassLoader().loadClass("com.lmax.disruptor.EventFactory");
            }
            catch (Exception e) {
                StatusLogger.getLogger().warn("Asynchronous loggers defined, but the disruptor library is not available.  Reverting to synchronous loggers.", (Throwable)e);
                async = false;
            }
        }
        if (configfile instanceof String) {
            this.configureLog4J2(async, (String)configfile, null);
        } else {
            this.configureLog4J2(async, null, configuration);
        }
        this.configurePax(configuration);
    }

    private void logImpl(Bundle bundle, int level, String message, Throwable exception, String fqcn) {
        String category = BackendSupport.category(bundle);
        PaxLogger logger = this.getLogger(bundle, category, fqcn);
        if (exception != null) {
            if (level < 1) {
                logger.audit(message, (Object)exception);
            } else {
                switch (level) {
                    case 1: {
                        logger.error(message, (Object)exception);
                        break;
                    }
                    case 2: {
                        logger.warn(message, (Object)exception);
                        break;
                    }
                    case 3: {
                        logger.info(message, (Object)exception);
                        break;
                    }
                    case 4: {
                        logger.debug(message, (Object)exception);
                        break;
                    }
                    default: {
                        logger.trace(message, (Object)exception);
                        break;
                    }
                }
            }
        } else if (level < 1) {
            logger.audit(message);
        } else {
            switch (level) {
                case 1: {
                    logger.error(message);
                    break;
                }
                case 2: {
                    logger.warn(message);
                    break;
                }
                case 3: {
                    logger.info(message);
                    break;
                }
                case 4: {
                    logger.debug(message);
                    break;
                }
                default: {
                    logger.trace(message);
                }
            }
        }
    }

    void handleEvents(String name, Bundle bundle, ServiceReference<?> sr, LogLevel level, String message, Throwable exception) {
        LogEntryImpl entry;
        LogEntryImpl logEntryImpl = entry = this.m_logReader != null || this.m_eventAdmin != null ? new LogEntryImpl(name, bundle, sr, level, message, exception) : null;
        if (this.m_logReader != null) {
            this.m_logReader.fireEvent(entry);
        }
        if (this.m_eventAdmin != null) {
            this.m_eventAdmin.postEvent(bundle, level, (LogEntry)entry, message, exception, sr, this.getPaxContext().getContext());
        }
    }

    void configureDefaults() {
        String levelName = BackendSupport.defaultLogLevel(this.m_bundleContext);
        java.util.logging.Level julLevel = BackendSupport.toJULLevel(levelName);
        this.m_r7LogLevel = BackendSupport.convertR7LogLevel(levelName, LogLevel.DEBUG);
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(julLevel);
        this.configureLog4J2(false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLog4J2(boolean async, String configFileName, Dictionary<String, ?> configuration) {
        Throwable problem = null;
        File file = null;
        if (configFileName != null) {
            file = new File(configFileName);
        }
        if (file != null && !file.isFile()) {
            if (configFileName.contains(",")) {
                file = null;
            } else {
                StatusLogger.getLogger().warn("Configuration file '" + file + "' is not available. Default configuration will be used.");
                file = null;
                configFileName = null;
            }
        }
        if (configFileName == null && configuration == null && !this.emptyConfiguration.compareAndSet(false, true)) {
            this.m_configNotifier.configurationDone();
            return;
        }
        Properties props = null;
        if (configuration != null) {
            props = new Properties();
            Object defaultsFile = configuration.get("org.ops4j.pax.logging.log4j2.defaults.file");
            if (defaultsFile != null) {
                try (FileInputStream inputStream = new FileInputStream(defaultsFile.toString());){
                    props.load(inputStream);
                }
                catch (IOException e) {
                    StatusLogger.getLogger().error("Error reading defaults file.", (Throwable)e);
                }
            }
            Enumeration<String> keys = configuration.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                props.setProperty(key, configuration.get(key).toString());
            }
            if ((props = PropertiesUtil.extractSubset((Properties)props, (String)"log4j2")).size() == 0 && this.emptyConfiguration.get()) {
                this.m_configNotifier.configurationDone();
                return;
            }
        }
        try {
            this.lock(true);
            if (this.m_log4jContext != null) {
                this.m_log4jContext.stop();
            }
            if (this.m_log4jContext == null || async != this.m_async) {
                this.m_log4jContext = async ? new AsyncLoggerContext(LOGGER_CONTEXT_NAME) : new LoggerContext(LOGGER_CONTEXT_NAME);
                this.m_async = async;
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                if (props != null) {
                    if (props.size() == 0) {
                        this.configureDefaults();
                        return;
                    }
                    this.emptyConfiguration.set(false);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    props.store(baos, null);
                    ConfigurationSource src = new ConfigurationSource(new ByteArrayInputStream(baos.toByteArray()));
                    PropertiesConfiguration config = new PropertiesConfigurationFactory().getConfiguration(this.m_log4jContext, src);
                    this.m_log4jContext.start(config);
                    StatusLogger.getLogger().info("Log4J2 configured using configuration from passed properties");
                } else if (configFileName != null) {
                    this.emptyConfiguration.set(false);
                    ConfigurationFactory factory = ConfigurationFactory.getInstance();
                    PaxPropertySource.updateFileConfiguration((String)configFileName);
                    PropertiesUtil.getProperties().reload();
                    Configuration config = factory.getConfiguration(this.m_log4jContext, LOGGER_CONTEXT_NAME, null);
                    this.m_log4jContext.start(config);
                    StatusLogger.getLogger().info("Log4J2 configured using file '" + configFileName + "'.");
                } else {
                    this.m_log4jContext.start(new DefaultConfiguration());
                    Object l = Level.getLevel((String)this.m_r7LogLevel.name());
                    if (l == null) {
                        l = Level.DEBUG;
                    }
                    this.m_log4jContext.getConfiguration().getLoggerConfig("").setLevel((Level)l);
                    StatusLogger.getLogger().info("Log4J2 configured using default configuration.");
                }
                if (this.errorsAsException) {
                    for (StatusData sd : StatusLogger.getLogger().getStatusData()) {
                        if (!sd.getLevel().isMoreSpecificThan(Level.ERROR) || sd.getThrowable() == null) continue;
                        throw sd.getThrowable();
                    }
                }
            }
            catch (Throwable e) {
                StatusLogger.getLogger().error("Log4J2 configuration problem: " + e.getMessage(), e);
                problem = e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            this.m_log4jContext.updateLoggers();
        }
        finally {
            this.unlock(true);
        }
        this.setLevelToJavaLogging();
        if (problem == null) {
            this.m_configNotifier.configurationDone();
        } else {
            this.m_configNotifier.configurationError(problem);
        }
    }

    private void setLevelToJavaLogging() {
        Enumeration<String> enum_ = LogManager.getLogManager().getLoggerNames();
        while (enum_.hasMoreElements()) {
            String name = enum_.nextElement();
            Logger.getLogger(name).setLevel(null);
        }
        for (org.apache.logging.log4j.core.Logger logger : this.m_log4jContext.getLoggers()) {
            if (logger == null) continue;
            Level l = logger.getLevel();
            java.util.logging.Level julLevel = BackendSupport.toJULLevel(l.name());
            if (logger.getName().equals("")) {
                Logger.getGlobal().setLevel(julLevel);
                Logger.getLogger("").setLevel(julLevel);
                Logger.getLogger("global").setLevel(julLevel);
                continue;
            }
            Logger.getLogger(logger.getName()).setLevel(julLevel);
        }
    }

    private void configurePax(Dictionary<String, ?> config) {
        Object size = config.get("org.ops4j.pax.logging.logReaderServiceSize");
        if (size == null) {
            size = config.get("pax.logging.entries.size");
        }
        if (null != size && this.m_logReader != null) {
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)size));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        class ManagedPaxLoggingService
        implements PaxLoggingService {
            private final String FQCN;

            ManagedPaxLoggingService() {
                this.FQCN = ManagedPaxLoggingService.class.getName();
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, null, this.FQCN);
            }

            public void log(int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, exception, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, null, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, exception, this.FQCN);
            }

            public LogLevel getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }

            public org.osgi.service.log.Logger getLogger(String name) {
                return PaxLoggingServiceImpl.this.getLogger(bundle, name, PaxLoggerImpl.FQCN);
            }

            public org.osgi.service.log.Logger getLogger(Class<?> clazz) {
                return PaxLoggingServiceImpl.this.getLogger(bundle, clazz.getName(), PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle, name, loggerType, PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle, clazz.getName(), loggerType, PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle2, String name, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle2, name, loggerType, PaxLoggerImpl.FQCN);
            }
        }
        return new ManagedPaxLoggingService();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    static {
        PluginManager.addPackage(PaxOsgiAppender.class.getPackage().getName());
        PluginManager.addPackage(JsonTemplateLayout.class.getPackage().getName());
        PluginManager.addPackage(LoggerResolverFactory.class.getPackage().getName());
        PluginManager.addPackage(RecyclerFactoryConverter.class.getPackage().getName());
    }
}

